/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.repository;

import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.repository.VotesboardRepositoryCustom;
import com.example.soso.users.domain.entity.Users;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VotesboardRepository
extends JpaRepository<Votesboard, Long>,
VotesboardRepositoryCustom {
    @Query(value="SELECT v FROM Votesboard v WHERE v.id = :id AND v.deleted = false")
    public Optional<Votesboard> findByIdAndDeletedFalse(@Param(value="id") Long var1);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false AND v.id < :cursor ORDER BY v.id DESC")
    public List<Votesboard> findAllByCursorWithoutStatus(@Param(value="cursor") Long var1, Pageable var2);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false ORDER BY v.id DESC")
    public List<Votesboard> findAllWithoutStatus(Pageable var1);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false AND v.endTime > :now AND v.id < :cursor ORDER BY v.id DESC")
    public List<Votesboard> findInProgressByCursor(@Param(value="cursor") Long var1, @Param(value="now") LocalDateTime var2, Pageable var3);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false AND v.endTime > :now ORDER BY v.id DESC")
    public List<Votesboard> findInProgress(@Param(value="now") LocalDateTime var1, Pageable var2);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false AND v.endTime <= :now AND v.id < :cursor ORDER BY v.id DESC")
    public List<Votesboard> findCompletedByCursor(@Param(value="cursor") Long var1, @Param(value="now") LocalDateTime var2, Pageable var3);

    @Query(value="SELECT v FROM Votesboard v WHERE v.deleted = false AND v.endTime <= :now ORDER BY v.id DESC")
    public List<Votesboard> findCompleted(@Param(value="now") LocalDateTime var1, Pageable var2);

    public long countByUserAndDeletedFalse(Users var1);

    public long countByDeletedFalse();

    @Query(value="SELECT COUNT(v) FROM Votesboard v WHERE v.deleted = false AND v.endTime > :now")
    public long countInProgress(@Param(value="now") LocalDateTime var1);

    @Query(value="SELECT COUNT(v) FROM Votesboard v WHERE v.deleted = false AND v.endTime <= :now")
    public long countCompleted(@Param(value="now") LocalDateTime var1);
}

