/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.service;

import com.example.soso.community.votesboard.comment.domain.repository.VotesboardCommentRepository;
import com.example.soso.community.votesboard.domain.dto.VoteRequest;
import com.example.soso.community.votesboard.domain.dto.VotesboardCreateRequest;
import com.example.soso.community.votesboard.domain.dto.VotesboardCursorResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardDetailResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardMapper;
import com.example.soso.community.votesboard.domain.dto.VotesboardSummary;
import com.example.soso.community.votesboard.domain.dto.VotesboardUpdateRequest;
import com.example.soso.community.votesboard.domain.entity.VoteOption;
import com.example.soso.community.votesboard.domain.entity.VoteResult;
import com.example.soso.community.votesboard.domain.entity.VoteStatus;
import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.domain.entity.VotesboardImage;
import com.example.soso.community.votesboard.dto.VotesboardSortType;
import com.example.soso.community.votesboard.repository.VoteOptionRepository;
import com.example.soso.community.votesboard.repository.VoteResultRepository;
import com.example.soso.community.votesboard.repository.VotesboardLikeRepository;
import com.example.soso.community.votesboard.repository.VotesboardRepository;
import com.example.soso.community.votesboard.service.VotesboardService;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.image.service.ImageUploadService;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotesboardServiceImpl
implements VotesboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VotesboardServiceImpl.class);
    private static final String VOTESBOARD_DIRECTORY = "votesboard";
    private final VotesboardRepository votesboardRepository;
    private final VoteOptionRepository voteOptionRepository;
    private final VoteResultRepository voteResultRepository;
    private final UsersRepository usersRepository;
    private final VotesboardCommentRepository votesboardCommentRepository;
    private final VotesboardLikeRepository votesboardLikeRepository;
    private final VotesboardMapper votesboardMapper;
    private final ImageUploadService imageUploadService;

    @Transactional
    public Long createVotesboard(VotesboardCreateRequest request, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc2dc\uc791: userId={}, optionCount={}, imageCount={}", new Object[]{userId, request.getVoteOptions().size(), request.getImages() != null ? request.getImages().size() : 0});
        Users user = this.findUserById(userId);
        Votesboard votesboard = this.votesboardMapper.toEntity(request, user);
        Votesboard savedPost = (Votesboard)this.votesboardRepository.save((Object)votesboard);
        if (request.getImages() != null && !request.getImages().isEmpty()) {
            List imageUrls = this.imageUploadService.uploadImages(request.getImages(), VOTESBOARD_DIRECTORY);
            this.saveVotesboardImages(savedPost, imageUrls);
        }
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc644\ub8cc: postId={}, optionCount={}, imageCount={}", new Object[]{savedPost.getId(), savedPost.getVoteOptions().size(), savedPost.getImages().size()});
        return savedPost.getId();
    }

    @Transactional
    public VotesboardDetailResponse getVotesboard(Long postId, String userId) {
        log.debug("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc870\ud68c: postId={}, userId={}", (Object)postId, (Object)userId);
        Votesboard votesboard = this.findVotesboardById(postId);
        votesboard.increaseViewCount();
        long commentCount = this.votesboardCommentRepository.countByVotesboardIdAndDeletedFalse(postId);
        long likeCount = this.votesboardLikeRepository.countByVotesboard(votesboard);
        List userVoteResults = null;
        Boolean isLiked = null;
        if (userId != null) {
            Users user = this.findUserById(userId);
            userVoteResults = this.voteResultRepository.findAllByUserAndVotesboard(user, votesboard);
            isLiked = this.votesboardLikeRepository.existsByVotesboardIdAndUserId(postId, userId);
        }
        return this.votesboardMapper.toDetailResponse(votesboard, commentCount, userVoteResults, likeCount, isLiked, userId);
    }

    public VotesboardCursorResponse getVotesboardsByCursor(VoteStatus status, VotesboardSortType sort, int size, String cursor, String userId) {
        List posts;
        boolean hasNext;
        log.debug("\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c: status={}, sort={}, size={}, cursor={}, userId={}", new Object[]{status, sort, size, cursor, userId});
        Long cursorId = null;
        if (cursor != null && !cursor.isEmpty()) {
            try {
                cursorId = Long.parseLong(cursor);
            }
            catch (NumberFormatException e) {
                log.warn("\uc798\ubabb\ub41c \ucee4\uc11c \ud615\uc2dd: cursor={}", (Object)cursor);
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_CURSOR);
            }
        }
        boolean bl = hasNext = (posts = this.votesboardRepository.findAllBySortAndCursor(status, sort, cursorId, size)).size() > size;
        if (hasNext) {
            posts = posts.subList(0, size);
        }
        String nextCursor = hasNext && !posts.isEmpty() ? String.valueOf(((Votesboard)posts.get(posts.size() - 1)).getId()) : null;
        LocalDateTime now = LocalDateTime.now();
        long totalCount = status == null ? this.votesboardRepository.countByDeletedFalse() : (status == VoteStatus.IN_PROGRESS ? this.votesboardRepository.countInProgress(now) : this.votesboardRepository.countCompleted(now));
        boolean isAuthorized = userId != null;
        Users user = userId != null ? this.findUserById(userId) : null;
        List<VotesboardSummary> summaries = posts.stream().map(post -> {
            long commentCount = this.votesboardCommentRepository.countByVotesboardIdAndDeletedFalse(post.getId());
            long likeCount = this.votesboardLikeRepository.countByVotesboard(post);
            Boolean isLiked = userId != null ? Boolean.valueOf(this.votesboardLikeRepository.existsByVotesboardIdAndUserId(post.getId(), userId)) : null;
            Boolean hasVoted = userId != null ? Boolean.valueOf(this.voteResultRepository.existsByUserAndVotesboard(user, post)) : null;
            return this.votesboardMapper.toSummaryResponse(post, commentCount, likeCount, isLiked, hasVoted);
        }).toList();
        return this.votesboardMapper.toListResponse(summaries, nextCursor, hasNext, totalCount, isAuthorized);
    }

    @Transactional
    public void updateVotesboard(Long postId, VotesboardUpdateRequest request, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Votesboard votesboard = this.findVotesboardById(postId);
        Users user = this.findUserById(userId);
        this.validateAuthor(votesboard, user);
        if (request.getDeleteImageIds() != null && !request.getDeleteImageIds().isEmpty()) {
            this.deleteVotesboardImages(votesboard, request.getDeleteImageIds());
        }
        List newImageUrls = Collections.emptyList();
        if (request.getImages() != null && !request.getImages().isEmpty()) {
            int newImageCount;
            int currentImageCount = votesboard.getImages().size();
            if (currentImageCount + (newImageCount = request.getImages().size()) > this.imageUploadService.getMaxImageCount()) {
                throw new IllegalArgumentException("\ucd1d \uc774\ubbf8\uc9c0 \uac1c\uc218\ub294 " + this.imageUploadService.getMaxImageCount() + "\uac1c\ub97c \ucd08\uacfc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            newImageUrls = this.imageUploadService.uploadImages(request.getImages(), VOTESBOARD_DIRECTORY);
            this.saveVotesboardImages(votesboard, newImageUrls);
        }
        votesboard.updatePost(request.getTitle(), request.getContent(), request.getCategory());
        if (request.getEndTime() != null || request.getAllowRevote() != null || request.getAllowMultipleChoice() != null) {
            LocalDateTime endTime = request.getEndTime() != null ? request.getEndTime() : votesboard.getEndTime();
            boolean allowRevote = request.getAllowRevote() != null ? request.getAllowRevote().booleanValue() : votesboard.isAllowRevote();
            boolean allowMultipleChoice = request.getAllowMultipleChoice() != null ? request.getAllowMultipleChoice().booleanValue() : votesboard.isAllowMultipleChoice();
            votesboard.updateVoteSettings(endTime, allowRevote, allowMultipleChoice);
        }
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc644\ub8cc: postId={}, newImageCount={}", (Object)postId, (Object)newImageUrls.size());
    }

    @Transactional
    public void deleteVotesboard(Long postId, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Votesboard votesboard = this.findVotesboardById(postId);
        Users user = this.findUserById(userId);
        this.validateAuthor(votesboard, user);
        votesboard.delete();
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc644\ub8cc: postId={}", (Object)postId);
    }

    @Transactional
    public void vote(Long postId, VoteRequest request, String userId) {
        log.info("\ud22c\ud45c \ucc38\uc5ec \uc2dc\uc791: postId={}, userId={}, optionIds={}", new Object[]{postId, userId, request.getVoteOptionIds()});
        Votesboard votesboard = this.findVotesboardById(postId);
        Users user = this.findUserById(userId);
        List selectedOptionIds = request.getVoteOptionIds();
        if (!votesboard.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        if (this.voteResultRepository.existsByUserAndVotesboard(user, votesboard)) {
            throw new PostException((BaseErrorCode)PostErrorCode.ALREADY_VOTED);
        }
        int totalOptions = votesboard.getVoteOptions().size();
        int selectedCount = selectedOptionIds.size();
        if (votesboard.isAllowMultipleChoice()) {
            if (selectedCount == 0) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_VOTE_COUNT);
            }
            if (selectedCount >= totalOptions) {
                throw new PostException((BaseErrorCode)PostErrorCode.TOO_MANY_VOTE_OPTIONS);
            }
        } else if (selectedCount != 1) {
            throw new PostException((BaseErrorCode)PostErrorCode.SINGLE_VOTE_REQUIRED);
        }
        if ((long)selectedOptionIds.size() != selectedOptionIds.stream().distinct().count()) {
            throw new PostException((BaseErrorCode)PostErrorCode.DUPLICATE_VOTE_OPTION);
        }
        for (Long optionId : selectedOptionIds) {
            VoteOption selectedOption = this.findVoteOptionById(optionId);
            if (!selectedOption.getVotesboard().getId().equals(postId)) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_VOTE_OPTION);
            }
            VoteResult voteResult = VoteResult.builder().user(user).votesboard(votesboard).voteOption(selectedOption).build();
            this.voteResultRepository.save((Object)voteResult);
            selectedOption.increaseVoteCount();
        }
        votesboard.increaseTotalVotes();
        log.info("\ud22c\ud45c \ucc38\uc5ec \uc644\ub8cc: postId={}, userId={}, optionIds={}", new Object[]{postId, userId, selectedOptionIds});
    }

    @Transactional
    public void changeVote(Long postId, VoteRequest request, String userId) {
        List sortedNewOptionIds;
        log.info("\ud22c\ud45c \ubcc0\uacbd \uc2dc\uc791: postId={}, userId={}, newOptionIds={}", new Object[]{postId, userId, request.getVoteOptionIds()});
        Votesboard votesboard = this.findVotesboardById(postId);
        Users user = this.findUserById(userId);
        List newOptionIds = request.getVoteOptionIds();
        if (!votesboard.isAllowRevote()) {
            throw new PostException((BaseErrorCode)PostErrorCode.REVOTE_NOT_ALLOWED);
        }
        if (!votesboard.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        List existingVotes = this.voteResultRepository.findAllByUserAndVotesboard(user, votesboard);
        if (existingVotes.isEmpty()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_NOT_FOUND);
        }
        int totalOptions = votesboard.getVoteOptions().size();
        int selectedCount = newOptionIds.size();
        if (votesboard.isAllowMultipleChoice()) {
            if (selectedCount == 0) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_VOTE_COUNT);
            }
            if (selectedCount >= totalOptions) {
                throw new PostException((BaseErrorCode)PostErrorCode.TOO_MANY_VOTE_OPTIONS);
            }
        } else if (selectedCount != 1) {
            throw new PostException((BaseErrorCode)PostErrorCode.SINGLE_VOTE_REQUIRED);
        }
        if ((long)newOptionIds.size() != newOptionIds.stream().distinct().count()) {
            throw new PostException((BaseErrorCode)PostErrorCode.DUPLICATE_VOTE_OPTION);
        }
        List<Long> existingOptionIds = existingVotes.stream().map(vr -> vr.getVoteOption().getId()).sorted().toList();
        if (existingOptionIds.equals(sortedNewOptionIds = newOptionIds.stream().sorted().toList())) {
            log.warn("\ub3d9\uc77c\ud55c \uc635\uc158\uc73c\ub85c \uc7ac\ud22c\ud45c \uc2dc\ub3c4: postId={}, userId={}, optionIds={}", new Object[]{postId, userId, newOptionIds});
            return;
        }
        for (VoteResult existingVote : existingVotes) {
            existingVote.getVoteOption().decreaseVoteCount();
            this.voteResultRepository.delete((Object)existingVote);
        }
        for (Long optionId : newOptionIds) {
            VoteOption newOption = this.findVoteOptionById(optionId);
            if (!newOption.getVotesboard().getId().equals(postId)) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_VOTE_OPTION);
            }
            VoteResult voteResult = VoteResult.builder().user(user).votesboard(votesboard).voteOption(newOption).build();
            this.voteResultRepository.save((Object)voteResult);
            newOption.increaseVoteCount();
        }
        log.info("\ud22c\ud45c \ubcc0\uacbd \uc644\ub8cc: postId={}, userId={}, newOptionIds={}", new Object[]{postId, userId, newOptionIds});
    }

    @Transactional
    public void cancelVote(Long postId, String userId) {
        log.info("\ud22c\ud45c \ucde8\uc18c \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Votesboard votesboard = this.findVotesboardById(postId);
        Users user = this.findUserById(userId);
        if (!votesboard.isAllowRevote()) {
            throw new PostException((BaseErrorCode)PostErrorCode.REVOTE_NOT_ALLOWED);
        }
        if (!votesboard.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        List voteResults = this.voteResultRepository.findAllByUserAndVotesboard(user, votesboard);
        if (voteResults.isEmpty()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_NOT_FOUND);
        }
        for (VoteResult voteResult : voteResults) {
            voteResult.getVoteOption().decreaseVoteCount();
            this.voteResultRepository.delete((Object)voteResult);
        }
        votesboard.decreaseTotalVotes();
        log.info("\ud22c\ud45c \ucde8\uc18c \uc644\ub8cc: postId={}, userId={}, canceledCount={}", new Object[]{postId, userId, voteResults.size()});
    }

    private Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    private Votesboard findVotesboardById(Long postId) {
        return (Votesboard)this.votesboardRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
    }

    private VoteOption findVoteOptionById(Long optionId) {
        return (VoteOption)this.voteOptionRepository.findById((Object)optionId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.VOTE_OPTION_NOT_FOUND));
    }

    private void validateAuthor(Votesboard votesboard, Users user) {
        if (!votesboard.getUser().getId().equals(user.getId())) {
            throw new UserAuthException((BaseErrorCode)UserErrorCode.UNAUTHORIZED_ACCESS);
        }
    }

    private void saveVotesboardImages(Votesboard votesboard, List<String> imageUrls) {
        for (String imageUrl : imageUrls) {
            VotesboardImage votesboardImage = VotesboardImage.builder().votesboard(votesboard).imageUrl(imageUrl).sequence(votesboard.getImages().size()).build();
            votesboard.addImage(votesboardImage);
        }
    }

    private void deleteVotesboardImages(Votesboard votesboard, List<Long> deleteImageIds) {
        List<VotesboardImage> imagesToDelete = votesboard.getImages().stream().filter(image -> deleteImageIds.contains(image.getId())).toList();
        for (VotesboardImage image2 : imagesToDelete) {
            this.imageUploadService.deleteImage(image2.getImageUrl());
            votesboard.getImages().remove(image2);
        }
    }

    @Generated
    public VotesboardServiceImpl(VotesboardRepository votesboardRepository, VoteOptionRepository voteOptionRepository, VoteResultRepository voteResultRepository, UsersRepository usersRepository, VotesboardCommentRepository votesboardCommentRepository, VotesboardLikeRepository votesboardLikeRepository, VotesboardMapper votesboardMapper, ImageUploadService imageUploadService) {
        this.votesboardRepository = votesboardRepository;
        this.voteOptionRepository = voteOptionRepository;
        this.voteResultRepository = voteResultRepository;
        this.usersRepository = usersRepository;
        this.votesboardCommentRepository = votesboardCommentRepository;
        this.votesboardLikeRepository = votesboardLikeRepository;
        this.votesboardMapper = votesboardMapper;
        this.imageUploadService = imageUploadService;
    }
}

