/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.kakao.service;

import com.example.soso.kakao.controller.KakaoApiClient;
import com.example.soso.kakao.controller.KakaoAuthClient;
import com.example.soso.kakao.dto.KakaoTokenResponse;
import com.example.soso.kakao.dto.KakaoUserProfileDto;
import com.example.soso.kakao.dto.KakaoUserResponse;
import com.example.soso.kakao.mapper.KakaoMapper;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KakaoOAuthService {
    private final KakaoAuthClient kakaoAuthClient;
    private final KakaoApiClient kakaoApiClient;
    @Value(value="${oauth.kakao.client-id}")
    private String clientId;

    public KakaoUserProfileDto fetchUserProfile(String code, String codeVerifier, String redirectUri) {
        KakaoTokenResponse tokenResponse = this.kakaoAuthClient.getToken("authorization_code", this.clientId, redirectUri, code, codeVerifier);
        KakaoUserResponse userResponse = this.kakaoApiClient.getUserInfo("Bearer " + tokenResponse.accessToken());
        return KakaoMapper.from((KakaoUserResponse)userResponse);
    }

    @Generated
    public KakaoOAuthService(KakaoAuthClient kakaoAuthClient, KakaoApiClient kakaoApiClient) {
        this.kakaoAuthClient = kakaoAuthClient;
        this.kakaoApiClient = kakaoApiClient;
    }
}

