/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.sigungu.domain.entity;

import com.example.soso.sigungu.domain.entity.SigunguCode;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="sigungu_code", indexes={@Index(name="idx_sigungu_code", columnList="code")})
public class SigunguCode {
    @Id
    @Column(name="code", length=5, nullable=false)
    private String code;
    @Column(name="sido", length=50, nullable=false)
    private String sido;
    @Column(name="sigungu", length=50, nullable=false)
    private String sigungu;
    @Column(name="full_name", length=100, nullable=false)
    private String fullName;

    public SigunguCode(String code, String sido, String sigungu, String fullName) {
        this.code = code;
        this.sido = sido;
        this.sigungu = sigungu;
        this.fullName = fullName;
    }

    public static boolean isValidCode(String code) {
        if (code == null || code.length() != 5) {
            return false;
        }
        return code.matches("\\d{5}");
    }

    @Generated
    public static SigunguCodeBuilder builder() {
        return new SigunguCodeBuilder();
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getSido() {
        return this.sido;
    }

    @Generated
    public String getSigungu() {
        return this.sigungu;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    protected SigunguCode() {
    }
}

