/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.sigungu.service;

import com.example.soso.sigungu.domain.entity.SigunguCode;
import com.example.soso.sigungu.repository.SigunguCodeRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SigunguCodeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigunguCodeService.class);
    private final SigunguCodeRepository sigunguCodeRepository;
    private static final String DEFAULT_LOCATION = "\uc18c\uc18c \ud0c0\uc6b4";

    public String convertToAddress(String sigunguCode) {
        if (sigunguCode == null || sigunguCode.isBlank()) {
            log.debug("\uc2dc\uad70\uad6c \ucf54\ub4dc\uac00 null \ub610\ub294 \ube48 \ubb38\uc790\uc5f4\uc785\ub2c8\ub2e4. \uae30\ubcf8\uac12 \ubc18\ud658: {}", (Object)DEFAULT_LOCATION);
            return DEFAULT_LOCATION;
        }
        if (!SigunguCode.isValidCode((String)sigunguCode)) {
            log.warn("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc2dc\uad70\uad6c \ucf54\ub4dc \ud615\uc2dd: {}. \uae30\ubcf8\uac12 \ubc18\ud658: {}", (Object)sigunguCode, (Object)DEFAULT_LOCATION);
            return DEFAULT_LOCATION;
        }
        return this.sigunguCodeRepository.findByCode(sigunguCode).map(SigunguCode::getFullName).orElseGet(() -> {
            log.warn("\uc2dc\uad70\uad6c \ucf54\ub4dc {}\uc5d0 \ud574\ub2f9\ud558\ub294 \uc9c0\uc5ed\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uae30\ubcf8\uac12 \ubc18\ud658: {}", (Object)sigunguCode, (Object)DEFAULT_LOCATION);
            return DEFAULT_LOCATION;
        });
    }

    public String convertToAddressSafe(String sigunguCode) {
        try {
            return this.convertToAddress(sigunguCode);
        }
        catch (Exception e) {
            log.error("\uc2dc\uad70\uad6c \ucf54\ub4dc \ubcc0\ud658 \uc911 \uc608\uc678 \ubc1c\uc0dd. code: {}, error: {}", new Object[]{sigunguCode, e.getMessage(), e});
            return DEFAULT_LOCATION;
        }
    }

    public String getDefaultLocation() {
        return DEFAULT_LOCATION;
    }

    @Generated
    public SigunguCodeService(SigunguCodeRepository sigunguCodeRepository) {
        this.sigunguCodeRepository = sigunguCodeRepository;
    }
}

