/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.service;

import com.example.soso.global.config.CookieUtil;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.jwt.JwtProperties;
import com.example.soso.global.jwt.JwtProvider;
import com.example.soso.global.redis.RefreshTokenRedisRepository;
import com.example.soso.users.domain.dto.AgeRangeRequest;
import com.example.soso.users.domain.dto.BudgetRequest;
import com.example.soso.users.domain.dto.ExperienceRequest;
import com.example.soso.users.domain.dto.GenderRequest;
import com.example.soso.users.domain.dto.RegionRequest;
import com.example.soso.users.domain.dto.SignupCompleteResponse;
import com.example.soso.users.domain.dto.SignupSession;
import com.example.soso.users.domain.dto.TokenPair;
import com.example.soso.users.domain.dto.UserMapper;
import com.example.soso.users.domain.dto.UserResponse;
import com.example.soso.users.domain.entity.AgeRange;
import com.example.soso.users.domain.entity.BudgetRange;
import com.example.soso.users.domain.entity.Gender;
import com.example.soso.users.domain.entity.InterestRequest;
import com.example.soso.users.domain.entity.InterestType;
import com.example.soso.users.domain.entity.SignupStep;
import com.example.soso.users.domain.entity.StartupExperience;
import com.example.soso.users.domain.entity.UserType;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import com.example.soso.users.service.SignupService;
import com.example.soso.users.util.RandomNicknameGenerator;
import com.example.soso.users.util.SignupFlow;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignupServiceImpl
implements SignupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignupServiceImpl.class);
    private static final String SESSION_KEY = "signup";
    private final UsersRepository usersRepository;
    private final JwtProvider jwtProvider;
    private final JwtProperties jwtProperties;
    private final RefreshTokenRedisRepository redisService;
    private final UserMapper userMapper;
    private final CookieUtil cookieUtil;

    public SignupStep saveUserType(HttpSession session, UserType userType) {
        SignupSession signup = this.getValidatedSession(session);
        if (!SignupFlow.isFirstStep((SignupStep)SignupStep.USER_TYPE, (UserType)userType)) {
            log.warn("Invalid first step request: userType={}, sessionId={}", (Object)userType, (Object)(session != null ? session.getId() : "null"));
            throw new IllegalStateException("\uc798\ubabb\ub41c \ub2e8\uacc4\uc785\ub2c8\ub2e4.");
        }
        signup.setUserType(userType);
        log.debug("User type set to: {}", (Object)userType);
        SignupStep nextStep = SignupFlow.nextStep((UserType)userType, (SignupStep)SignupStep.USER_TYPE);
        signup.setCurrentStep(nextStep);
        session.setAttribute(SESSION_KEY, (Object)signup);
        log.info("Signup step processed: {} -> {}, UserType: {}", new Object[]{SignupStep.USER_TYPE, nextStep, userType});
        return nextStep;
    }

    public SignupStep saveRegion(HttpSession session, String regionId) {
        return this.processSignupStep(session, SignupStep.REGION, signup -> {
            signup.setRegionId(regionId);
            log.debug("Region set to: {}", (Object)regionId);
        });
    }

    public SignupStep saveAgeRange(HttpSession session, AgeRange ageRange) {
        return this.processSignupStep(session, SignupStep.AGE, signup -> {
            signup.setAgeRange(ageRange);
            log.debug("Age range set to: {}", (Object)ageRange);
        });
    }

    public SignupStep saveGender(HttpSession session, Gender gender) {
        return this.processSignupStep(session, SignupStep.GENDER, signup -> {
            signup.setGender(gender);
            log.debug("Gender set to: {}", (Object)gender);
        });
    }

    public SignupStep saveInterests(HttpSession session, List<InterestType> interests) {
        return this.processSignupStep(session, SignupStep.INTERESTS, signup -> {
            if (interests == null || interests.isEmpty()) {
                signup.setInterests(Collections.emptyList());
            } else {
                signup.setInterests(interests);
            }
            log.debug("Interests set to: {}", (Object)interests);
        });
    }

    public SignupStep saveBudget(HttpSession session, BudgetRange budget) {
        return this.processSignupStep(session, SignupStep.BUDGET, signup -> {
            signup.setBudget(budget);
            log.debug("Budget set to: {}", (Object)budget);
        });
    }

    public SignupStep saveExperience(HttpSession session, StartupExperience experience) {
        return this.processSignupStep(session, SignupStep.STARTUP, signup -> {
            signup.setStartupExperience(experience);
            log.debug("Experience set to: {}", (Object)experience);
        });
    }

    private SignupStep processSignupStep(HttpSession session, SignupStep currentStep, Consumer<SignupSession> updater) {
        SignupSession signup = this.getValidatedSession(session);
        this.validateStep(signup, currentStep);
        updater.accept(signup);
        SignupStep nextStep = SignupFlow.nextStep((UserType)signup.getUserType(), (SignupStep)currentStep);
        signup.setCurrentStep(nextStep);
        session.setAttribute(SESSION_KEY, (Object)signup);
        log.info("Signup step processed: {} -> {}, UserType: {}", new Object[]{currentStep, nextStep, signup.getUserType()});
        return nextStep;
    }

    public String saveNickname(HttpSession session) {
        String nickname;
        SignupSession signup;
        block3: {
            block2: {
                signup = this.getValidatedSession(session);
                this.validateStep(signup, SignupStep.NICKNAME);
                nickname = signup.getNickname();
                if (nickname == null) break block2;
                if (!this.usersRepository.existsByNickname(nickname)) break block3;
            }
            nickname = RandomNicknameGenerator.generateUniqueNickname(arg_0 -> ((UsersRepository)this.usersRepository).existsByNickname(arg_0));
        }
        signup.setNickname(nickname);
        SignupStep nextStep = SignupFlow.nextStep((UserType)signup.getUserType(), (SignupStep)SignupStep.NICKNAME);
        signup.setCurrentStep(nextStep);
        session.setAttribute(SESSION_KEY, (Object)signup);
        log.info("Nickname generated and set: {}", (Object)nickname);
        return nickname;
    }

    public SignupCompleteResponse completeSignup(HttpSession session, HttpServletResponse response) {
        SignupSession signup = this.getValidatedSession(session);
        this.validateStep(signup, SignupStep.COMPLETE);
        Users user = this.userMapper.fromSignupSession(signup, signup.getUsername(), signup.getEmail(), signup.getProfileImageUrl());
        user = (Users)this.usersRepository.save((Object)user);
        TokenPair tokenPair = this.generateTokens(user.getId());
        this.redisService.saveByUserId(user.getId(), tokenPair.refreshToken(), this.jwtProperties.getRefreshTokenValidityInMs());
        this.cookieUtil.addAccessTokenCookie(response, tokenPair.accessToken(), this.jwtProperties.getAccessTokenValidityInMs());
        this.cookieUtil.addRefreshTokenCookie(response, tokenPair.refreshToken(), this.jwtProperties.getRefreshTokenValidityInMs());
        UserResponse userResponse = this.userMapper.toUserResponse(user);
        session.removeAttribute(SESSION_KEY);
        return new SignupCompleteResponse(tokenPair.accessToken(), userResponse);
    }

    private TokenPair generateTokens(String userId) {
        String accessToken = this.jwtProvider.generateAccessToken(userId);
        String refreshToken = this.jwtProvider.generateRefreshToken();
        return new TokenPair(accessToken, refreshToken);
    }

    public RegionRequest getRegion(HttpSession session) {
        return (RegionRequest)this.getSignupData(session, signup -> new RegionRequest(signup.getRegionId()));
    }

    public AgeRangeRequest getAgeRange(HttpSession session) {
        return (AgeRangeRequest)this.getSignupData(session, signup -> new AgeRangeRequest(signup.getAgeRange()));
    }

    public GenderRequest getGender(HttpSession session) {
        return (GenderRequest)this.getSignupData(session, signup -> new GenderRequest(signup.getGender()));
    }

    public InterestRequest getInterests(HttpSession session) {
        return (InterestRequest)this.getSignupData(session, signup -> new InterestRequest(signup.getInterests()));
    }

    public BudgetRequest getBudget(HttpSession session) {
        return (BudgetRequest)this.getSignupData(session, signup -> new BudgetRequest(signup.getBudget()));
    }

    public ExperienceRequest getExperience(HttpSession session) {
        return (ExperienceRequest)this.getSignupData(session, signup -> new ExperienceRequest(signup.getStartupExperience()));
    }

    private <T> T getSignupData(HttpSession session, Function<SignupSession, T> extractor) {
        SignupSession signup = this.getValidatedSession(session);
        return extractor.apply(signup);
    }

    private void validateStep(SignupSession signup, SignupStep requestedStep) {
        if (signup == null) {
            log.warn("Signup session is null during step validation for requestedStep={}", (Object)requestedStep);
            throw new UserAuthException((BaseErrorCode)UserErrorCode.SESSION_NOT_VALID);
        }
        UserType userType = signup.getUserType();
        if (!SignupFlow.isStepSupported((UserType)userType, (SignupStep)requestedStep)) {
            log.warn("Signup step unsupported for userType: userType={}, requestedStep={}, email={}", new Object[]{userType, requestedStep, signup.getEmail()});
            throw new IllegalArgumentException("\ud574\ub2f9 \uc0ac\uc6a9\uc790 \uc720\ud615\uc5d0\uc11c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\ub294 \ub2e8\uacc4\uc785\ub2c8\ub2e4.");
        }
        SignupStep currentExpected = signup.getCurrentStep();
        if (SignupFlow.isValidProcessingStep((UserType)userType, (SignupStep)currentExpected, (SignupStep)requestedStep)) {
            return;
        }
        SignupStep nextStep = currentExpected != null ? currentExpected : SignupStep.COMPLETE;
        log.warn("Signup step validation failed: userType={}, currentStep={}, requestedStep={}, email={}", new Object[]{userType, currentExpected, requestedStep, signup.getEmail()});
        throw new IllegalArgumentException("\ub2e4\uc74c \ub2e8\uacc4: " + nextStep.name().toLowerCase());
    }

    private SignupSession getValidatedSession(HttpSession session) {
        SignupSession signup = (SignupSession)session.getAttribute(SESSION_KEY);
        if (signup == null) {
            log.warn("Signup session missing or expired: sessionId={}", (Object)(session != null ? session.getId() : "null"));
            throw new UserAuthException((BaseErrorCode)UserErrorCode.SESSION_NOT_VALID);
        }
        return signup;
    }

    @Generated
    public SignupServiceImpl(UsersRepository usersRepository, JwtProvider jwtProvider, JwtProperties jwtProperties, RefreshTokenRedisRepository redisService, UserMapper userMapper, CookieUtil cookieUtil) {
        this.usersRepository = usersRepository;
        this.jwtProvider = jwtProvider;
        this.jwtProperties = jwtProperties;
        this.redisService = redisService;
        this.userMapper = userMapper;
        this.cookieUtil = cookieUtil;
    }
}

