/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.post.repository;

import com.example.soso.community.common.likes.domain.QPostLike;
import com.example.soso.community.common.post.domain.dto.PostSortType;
import com.example.soso.community.common.post.domain.dto.PostSummaryResponse;
import com.example.soso.community.common.post.domain.dto.UserSummaryResponse;
import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.common.post.domain.entity.QPost;
import com.example.soso.community.common.post.domain.entity.QPostImage;
import com.example.soso.community.common.post.repository.PostRepositoryCustom;
import com.example.soso.community.common.post.util.PostCursorOrder;
import com.example.soso.community.common.post.util.PostCursorWhere;
import com.example.soso.users.domain.entity.QUsers;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Repository;

@Repository
public class PostRepositoryImpl
implements PostRepositoryCustom {
    private final JPAQueryFactory queryFactory;
    private final PostCursorWhere postCursorWhere;
    private final PostCursorOrder postCursorOrder;

    public List<PostSummaryResponse> findAllByCursorPaging(Category category, PostSortType sort, int size, String cursor, Long idAfter, String userId) {
        QPost post = QPost.post;
        QPostLike like = QPostLike.postLike;
        QUsers user = QUsers.users;
        BooleanBuilder condition = new BooleanBuilder();
        condition.and((Predicate)post.deleted.eq(Boolean.valueOf(false)));
        if (category != null) {
            condition.and((Predicate)post.category.eq((Object)category));
        }
        condition.and((Predicate)this.postCursorWhere.build(post, sort, cursor, idAfter));
        OrderSpecifier[] order = this.postCursorOrder.build(post, sort);
        QPostImage subImage = new QPostImage("subImage");
        JPQLQuery thumbnailUrlSubQuery = (JPQLQuery)JPAExpressions.select((Expression)subImage.imageUrl.min()).from(new EntityPath[]{subImage}).where(new Predicate[]{subImage.post.id.eq((Expression)post.id).and((Predicate)subImage.sequence.eq((Expression)JPAExpressions.select((Expression)subImage.sequence.min()).from(new EntityPath[]{subImage}).where(new Predicate[]{subImage.post.id.eq((Expression)post.id)})))});
        QPostImage countImage = new QPostImage("countImage");
        JPQLQuery imageCountSubQuery = (JPQLQuery)JPAExpressions.select((Expression)countImage.count().intValue()).from(new EntityPath[]{countImage}).where(new Predicate[]{countImage.post.id.eq((Expression)post.id)});
        if (userId == null) {
            return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.queryFactory.select((Expression)Projections.constructor(PostSummaryResponse.class, (Expression[])new Expression[]{post.id, post.title, post.content, post.category, post.likeCount, post.commentCount, post.viewCount, Expressions.nullExpression(Boolean.class), post.createdAt, post.updatedAt, thumbnailUrlSubQuery, imageCountSubQuery, Projections.constructor(UserSummaryResponse.class, (Expression[])new Expression[]{user.id, user.nickname, user.location, user.profileImageUrl, user.userType})})).from((EntityPath)post)).join((EntityPath)post.user, (Path)user)).where((Predicate)condition)).orderBy(order)).limit((long)(size + 1))).fetch();
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.queryFactory.select((Expression)Projections.constructor(PostSummaryResponse.class, (Expression[])new Expression[]{post.id, post.title, post.content, post.category, post.likeCount, post.commentCount, post.viewCount, like.id.isNotNull(), post.createdAt, post.updatedAt, thumbnailUrlSubQuery, imageCountSubQuery, Projections.constructor(UserSummaryResponse.class, (Expression[])new Expression[]{user.id, user.nickname, user.location, user.profileImageUrl, user.userType})})).from((EntityPath)post)).join((EntityPath)post.user, (Path)user)).leftJoin((EntityPath)like)).on((Predicate)like.post.id.eq((Expression)post.id).and((Predicate)like.user.id.eq((Object)userId)))).where((Predicate)condition)).orderBy(order)).limit((long)(size + 1))).fetch();
    }

    @Generated
    public PostRepositoryImpl(JPAQueryFactory queryFactory, PostCursorWhere postCursorWhere, PostCursorOrder postCursorOrder) {
        this.queryFactory = queryFactory;
        this.postCursorWhere = postCursorWhere;
        this.postCursorOrder = postCursorOrder;
    }
}

