/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.comment.service;

import com.example.soso.community.votesboard.comment.domain.dto.VotesboardCommentCreateRequest;
import com.example.soso.community.votesboard.comment.domain.dto.VotesboardCommentCreateResponse;
import com.example.soso.community.votesboard.comment.domain.dto.VotesboardCommentCursorResponse;
import com.example.soso.community.votesboard.comment.domain.dto.VotesboardCommentSortType;
import com.example.soso.community.votesboard.comment.domain.dto.VotesboardCommentUpdateRequest;
import com.example.soso.community.votesboard.comment.domain.entity.VotesboardComment;
import com.example.soso.community.votesboard.comment.domain.repository.VotesboardCommentLikeRepository;
import com.example.soso.community.votesboard.comment.domain.repository.VotesboardCommentRepository;
import com.example.soso.community.votesboard.comment.service.VotesboardCommentService;
import com.example.soso.community.votesboard.comment.service.VotesboardCommentServiceImpl;
import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.repository.VotesboardRepository;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotesboardCommentServiceImpl
implements VotesboardCommentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VotesboardCommentServiceImpl.class);
    private final VotesboardCommentRepository commentRepository;
    private final VotesboardCommentLikeRepository commentLikeRepository;
    private final VotesboardRepository votesboardRepository;
    private final UsersRepository usersRepository;

    @Transactional
    public VotesboardCommentCreateResponse createComment(Long votesboardId, VotesboardCommentCreateRequest request, String userId) {
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc791\uc131 \uc2dc\uc791: votesboardId={}, userId={}", (Object)votesboardId, (Object)userId);
        Votesboard votesboard = this.findVotesboardById(votesboardId);
        Users user = this.findUserById(userId);
        VotesboardComment parent = null;
        if (request.getParentCommentId() != null && (parent = this.findCommentById(request.getParentCommentId())).getParent() != null) {
            throw new PostException((BaseErrorCode)PostErrorCode.REPLY_DEPTH_EXCEEDED);
        }
        VotesboardComment comment = VotesboardComment.builder().votesboard(votesboard).user(user).parent(parent).content(request.getContent()).build();
        VotesboardComment savedComment = (VotesboardComment)this.commentRepository.save((Object)comment);
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc791\uc131 \uc644\ub8cc: commentId={}", (Object)savedComment.getId());
        return new VotesboardCommentCreateResponse(savedComment.getId());
    }

    public VotesboardCommentCursorResponse getCommentsByCursor(Long votesboardId, VotesboardCommentSortType sort, int size, String cursor, String userId) {
        boolean hasNext;
        log.debug("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \ubaa9\ub85d \uc870\ud68c: votesboardId={}, sort={}, size={}, userId={}", new Object[]{votesboardId, sort, size, userId});
        this.findVotesboardById(votesboardId);
        Sort sortOrder = this.buildSort(sort);
        PageRequest pageRequest = PageRequest.of((int)0, (int)(size + 1), (Sort)sortOrder);
        List comments = this.fetchComments(votesboardId, cursor, pageRequest, sort);
        boolean bl = hasNext = comments.size() > size;
        if (hasNext) {
            comments = comments.subList(0, size);
        }
        String nextCursor = hasNext && !comments.isEmpty() ? ((VotesboardComment)comments.get(comments.size() - 1)).getCreatedAt().toString() : null;
        List<VotesboardCommentCursorResponse.VotesboardCommentSummary> summaries = comments.stream().map(comment -> this.createCommentSummary(comment, userId)).toList();
        long total = this.commentRepository.countByVotesboardId(votesboardId);
        return VotesboardCommentCursorResponse.builder().comments(summaries).hasNext(hasNext).nextCursor(nextCursor).size(summaries.size()).total(total).isAuthorized(userId != null).build();
    }

    @Transactional
    public VotesboardCommentCreateResponse updateComment(Long votesboardId, Long commentId, VotesboardCommentUpdateRequest request, String userId) {
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc218\uc815 \uc2dc\uc791: commentId={}, userId={}", (Object)commentId, (Object)userId);
        VotesboardComment comment = this.findCommentById(commentId);
        this.validateCommentAuthor(comment, userId);
        if (comment.isDeleted()) {
            throw new PostException((BaseErrorCode)PostErrorCode.COMMENT_ALREADY_DELETED);
        }
        comment.updateContent(request.getContent());
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc218\uc815 \uc644\ub8cc: commentId={}", (Object)commentId);
        return new VotesboardCommentCreateResponse(comment.getId());
    }

    @Transactional
    public void deleteComment(Long votesboardId, Long commentId, String userId) {
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc0ad\uc81c \uc2dc\uc791: commentId={}, userId={}", (Object)commentId, (Object)userId);
        VotesboardComment comment = this.findCommentById(commentId);
        this.validateCommentAuthor(comment, userId);
        comment.delete();
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc0ad\uc81c \uc644\ub8cc: commentId={}", (Object)commentId);
    }

    @Transactional
    public void hardDeleteComment(Long votesboardId, Long commentId, String userId) {
        log.warn("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \ud558\ub4dc \uc0ad\uc81c \uc2dc\uc791: commentId={}, userId={}", (Object)commentId, (Object)userId);
        VotesboardComment comment = this.findCommentById(commentId);
        this.validateCommentAuthor(comment, userId);
        List childComments = this.commentRepository.findByParentId(commentId);
        this.commentRepository.deleteAll((Iterable)childComments);
        this.commentRepository.delete((Object)comment);
        log.warn("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \ud558\ub4dc \uc0ad\uc81c \uc644\ub8cc: commentId={}, deletedChildCount={}", (Object)commentId, (Object)childComments.size());
    }

    private Votesboard findVotesboardById(Long votesboardId) {
        return (Votesboard)this.votesboardRepository.findByIdAndDeletedFalse(votesboardId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
    }

    private Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    private VotesboardComment findCommentById(Long commentId) {
        return (VotesboardComment)this.commentRepository.findById((Object)commentId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.COMMENT_NOT_FOUND));
    }

    private void validateCommentAuthor(VotesboardComment comment, String userId) {
        if (!comment.getUser().getId().equals(userId)) {
            throw new UserAuthException((BaseErrorCode)UserErrorCode.UNAUTHORIZED_ACCESS);
        }
    }

    private Sort buildSort(VotesboardCommentSortType sortType) {
        return switch (1.$SwitchMap$com$example$soso$community$votesboard$comment$domain$dto$VotesboardCommentSortType[sortType.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"});
            case 2 -> Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createdAt"});
        };
    }

    private List<VotesboardComment> fetchComments(Long votesboardId, String cursor, PageRequest pageRequest, VotesboardCommentSortType sortType) {
        if (cursor == null) {
            return this.commentRepository.findByVotesboardId(votesboardId, (Pageable)pageRequest);
        }
        LocalDateTime cursorTime = LocalDateTime.parse(cursor);
        if (sortType == VotesboardCommentSortType.LATEST) {
            return this.commentRepository.findByVotesboardIdAndCreatedAtBefore(votesboardId, cursorTime, (Pageable)pageRequest);
        }
        return this.commentRepository.findByVotesboardIdAndCreatedAtAfter(votesboardId, cursorTime, (Pageable)pageRequest);
    }

    private VotesboardCommentCursorResponse.VotesboardCommentSummary createCommentSummary(VotesboardComment comment, String userId) {
        int replyCount = this.commentRepository.countByParentIdAndDeletedFalse(comment.getId());
        int depth = comment.getParent() != null ? 1 : 0;
        boolean isAuthorized = userId != null;
        boolean isAuthor = userId != null && comment.getUser().getId().equals(userId);
        Boolean isLiked = isAuthorized ? Boolean.valueOf(this.commentLikeRepository.existsByCommentIdAndUserId(comment.getId(), userId)) : null;
        Boolean canEdit = isAuthorized ? Boolean.valueOf(isAuthor) : null;
        Boolean canDelete = isAuthorized ? Boolean.valueOf(isAuthor) : null;
        return VotesboardCommentCursorResponse.VotesboardCommentSummary.builder().commentId(comment.getId()).votesboardId(comment.getVotesboard().getId()).parentCommentId(comment.getParent() != null ? comment.getParent().getId() : null).author(VotesboardCommentCursorResponse.CommentAuthorInfo.builder().userId(comment.getUser().getId()).nickname(comment.getUser().getNickname()).profileImageUrl(comment.getUser().getProfileImageUrl()).userType(comment.getUser().getUserType()).build()).content(comment.isDeleted() ? "\uc0ad\uc81c\ub41c \ub313\uae00\uc785\ub2c8\ub2e4" : comment.getContent()).replyCount(replyCount).likeCount(comment.getLikeCount()).depth(depth).deleted(comment.isDeleted()).isAuthor(isAuthor).isLiked(isLiked).canEdit(canEdit).canDelete(canDelete).createdAt(comment.getCreatedAt()).updatedAt(comment.getUpdatedAt()).build();
    }

    @Generated
    public VotesboardCommentServiceImpl(VotesboardCommentRepository commentRepository, VotesboardCommentLikeRepository commentLikeRepository, VotesboardRepository votesboardRepository, UsersRepository usersRepository) {
        this.commentRepository = commentRepository;
        this.commentLikeRepository = commentLikeRepository;
        this.votesboardRepository = votesboardRepository;
        this.usersRepository = usersRepository;
    }
}

