/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.controller;

import com.example.soso.community.votesboard.domain.dto.VoteRequest;
import com.example.soso.community.votesboard.domain.dto.VotesboardCreateRequest;
import com.example.soso.community.votesboard.domain.dto.VotesboardCreateResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardCursorResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardDetailResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardUpdateRequest;
import com.example.soso.community.votesboard.domain.entity.VoteStatus;
import com.example.soso.community.votesboard.dto.VotesboardSortType;
import com.example.soso.community.votesboard.service.VotesboardService;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.security.domain.CustomUserDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/community/votesboard"})
@Tag(name="Votesboard", description="\ud22c\ud45c \uac8c\uc2dc\ud310 API")
public class VotesboardController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VotesboardController.class);
    private final VotesboardService votesboardService;

    @PostMapping(consumes={"multipart/form-data"})
    @Operation(operationId="createVotesboard", summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131", description="\uc0c8\ub85c\uc6b4 \ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc791\uc131\ud569\ub2c8\ub2e4.\n\n**\ud2b9\uc9d5:**\n- 2-5\uac1c\uc758 \ud22c\ud45c \uc635\uc158 \ud544\uc218\n- \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc9c0\uc6d0 (\ucd5c\ub300 4\uc7a5)\n- \ud22c\ud45c \ub9c8\uac10 \uc2dc\uac04 \uc124\uc815 \ud544\uc218\n- \uc7ac\ud22c\ud45c \ud5c8\uc6a9 \uc5ec\ubd80 \uc124\uc815\n- \uc911\ubcf5 \uc120\ud0dd \ud5c8\uc6a9 \uc5ec\ubd80 \uc124\uc815\n- Multipart \ubc29\uc2dd\uc73c\ub85c \uc774\ubbf8\uc9c0\uc640 \ud14d\uc2a4\ud2b8 \ub370\uc774\ud130\ub97c \ud568\uaed8 \uc804\uc1a1\n- \uce74\ud14c\uace0\ub9ac \ud544\uc218 \uc120\ud0dd\n\n**\uc9c0\uc6d0 \ud30c\uc77c \ud615\uc2dd:** jpg, jpeg, png, gif, webp\n**\ucd5c\ub300 \ud30c\uc77c \ud06c\uae30:** 5MB per image\n", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=VotesboardCreateRequest.class))}))
    @ApiResponses(value={@ApiResponse(responseCode="201", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotesboardCreateResponse.class), examples={@ExampleObject(name="\uc131\uacf5 \uc751\ub2f5", value="{\"postId\": 1}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad (\uac80\uc99d \uc2e4\ud328, \uc774\ubbf8\uc9c0 \uad00\ub828 \uc624\ub958)", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ube48 \uc81c\ubaa9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[title] \uc81c\ubaa9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ube48 \ub0b4\uc6a9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[content] \ub0b4\uc6a9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc635\uc158 \uac1c\uc218 \ubd80\uc871", value="{\"code\": \"BAD_REQUEST\", \"message\": \"\ud22c\ud45c \uc635\uc158\uc740 \ucd5c\uc18c 2\uac1c, \ucd5c\ub300 5\uac1c\uae4c\uc9c0 \uac00\ub2a5\ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uacfc\uac70 \ub9c8\uac10 \uc2dc\uac04", value="{\"code\": \"BAD_REQUEST\", \"message\": \"\ud22c\ud45c \ub9c8\uac10 \uc2dc\uac04\uc740 \ubbf8\ub798 \uc2dc\uac04\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uce74\ud14c\uace0\ub9ac", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'invalid-category'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [daily-hobby, restaurant, living-convenience, neighborhood-news, startup, others]\"}"), @ExampleObject(name="\uc774\ubbf8\uc9c0 \uac1c\uc218 \ucd08\uacfc", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0\ub294 \ucd5c\ub300 4\uc7a5\uae4c\uc9c0 \uc5c5\ub85c\ub4dc \uac00\ub2a5\ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd\uc785\ub2c8\ub2e4. \uc9c0\uc6d0 \ud615\uc2dd: image/jpeg, image/jpg, image/png, image/gif, image/webp\"}"), @ExampleObject(name="\ube48 \ud30c\uc77c", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc778\uc99d \uc2e4\ud328", value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="413", description="\ud30c\uc77c \ud06c\uae30 \ucd08\uacfc (Spring multipart \uc81c\ud55c)", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"FILE_SIZE_EXCEEDED\", \"message\": \"\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \ucd5c\ub300 \uc5c5\ub85c\ub4dc \ud06c\uae30\ub294 5MB\uc785\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<VotesboardCreateResponse> createVotesboard(@ModelAttribute @Valid VotesboardCreateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        Long votesboardId = this.votesboardService.createVotesboard(request, userDetails.getUser().getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new VotesboardCreateResponse(votesboardId));
    }

    @GetMapping(value={"/{votesboardId}"})
    @Operation(operationId="getVotesboard", summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0c1\uc138 \uc870\ud68c", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc758 \uc0c1\uc138 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\ud2b9\uc9d5:**\n- \uc870\ud68c \uc2dc \uc870\ud68c\uc218 \uc790\ub3d9 \uc99d\uac00\n- \uc778\uc99d/\ube44\uc778\uc99d \uc0ac\uc6a9\uc790 \ubaa8\ub450 \uc870\ud68c \uac00\ub2a5\n- \uc778\uc99d \uc5ec\ubd80\uc5d0 \ub530\ub77c hasVoted, isLiked, canEdit, canDelete \uac12 \ubcc0\uacbd\n- \ud22c\ud45c \ucc38\uc5ec \uc5ec\ubd80\uc5d0 \ub530\ub77c selectedOptionIds \uac12 \ubcc0\uacbd\n\n**\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: true\n- hasVoted: boolean (\ud22c\ud45c \ucc38\uc5ec \uc5ec\ubd80 - \ucc38\uc5ec\ud588\uc73c\uba74 true, \uc548 \ud588\uc73c\uba74 false)\n- isLiked: boolean (\uc88b\uc544\uc694 \uc0c1\ud0dc)\n- canEdit: boolean (\uc218\uc815 \uad8c\ud55c - \uc791\uc131\uc790\uc778 \uacbd\uc6b0 true)\n- canDelete: boolean (\uc0ad\uc81c \uad8c\ud55c - \uc791\uc131\uc790\uc778 \uacbd\uc6b0 true)\n- selectedOptionIds: \ud22c\ud45c\ud55c \uc635\uc158 ID \ubaa9\ub85d (\ud22c\ud45c \uc804\uc774\uba74 \ube48 \ubc30\uc5f4, \ud22c\ud45c \ud6c4\uc5d0\ub294 \uc120\ud0dd\ud55c \uc635\uc158 ID\ub4e4)\n\n**\ube44\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: false\n- hasVoted: null\n- isLiked: null\n- canEdit: null\n- canDelete: null\n- selectedOptionIds: \ube48 \ubc30\uc5f4\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc870\ud68c \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotesboardDetailResponse.class), examples={@ExampleObject(name="\uc778\uc99d \uc0ac\uc6a9\uc790 (\ubcf8\uc778 \uc791\uc131, \ud22c\ud45c \uc804)", value="{\"postId\":1,\"author\":{\"userId\":\"author123\",\"nickname\":\"\uc791\uc131\uc790\",\"address\":\"\uc11c\uc6b8\uc2dc \uac15\ub0a8\uad6c\",\"profileImageUrl\":\"https://cdn.example.com/profile.jpg\",\"userType\":\"INHABITANT\"},\"category\":\"restaurant\",\"title\":\"\uc6b0\ub9ac \ub3d9\ub124 \uce74\ud398 \uc120\ud638\ub3c4 \uc870\uc0ac\",\"content\":\"\uc5ec\ub7ec\ubd84\uc774 \uac00\uc7a5 \uc88b\uc544\ud558\ub294 \uce74\ud398 \uc2a4\ud0c0\uc77c\uc740 \ubb34\uc5c7\uc778\uac00\uc694?\",\"images\":[{\"imageId\":1,\"imageUrl\":\"https://cdn.example.com/vote1.jpg\",\"sequence\":0}],\"voteOptions\":[{\"id\":1,\"content\":\"\uc870\uc6a9\ud55c \ubd84\uc704\uae30\",\"sequence\":0,\"voteCount\":15,\"percentage\":37.5},{\"id\":2,\"content\":\"\ud65c\uae30\ucc2c \ubd84\uc704\uae30\",\"sequence\":1,\"voteCount\":10,\"percentage\":25.0},{\"id\":3,\"content\":\"\uc791\uc5c5\ud558\uae30 \uc88b\uc740 \uacf3\",\"sequence\":2,\"voteCount\":15,\"percentage\":37.5}],\"hasVoted\":false,\"voteInfo\":{\"selectedOptionIds\":[],\"totalVotes\":40,\"voteStatus\":\"IN_PROGRESS\",\"endTime\":\"2025-12-31T23:59:59\",\"allowRevote\":true,\"allowMultipleChoice\":false},\"viewCount\":120,\"commentCount\":5,\"likeCount\":8,\"isLiked\":false,\"isAuthorized\":true,\"isAuthor\":true,\"canEdit\":true,\"canDelete\":true,\"createdAt\":\"2025-01-01T10:00:00\",\"updatedAt\":\"2025-01-01T10:00:00\"}"), @ExampleObject(name="\uc778\uc99d \uc0ac\uc6a9\uc790 (\ub2e4\ub978 \uc0ac\ub78c \uae00, \ud22c\ud45c \uc644\ub8cc)", value="{\"postId\":2,\"author\":{\"userId\":\"other-user\",\"nickname\":\"\ub2e4\ub978\uc0ac\uc6a9\uc790\",\"address\":\"\uc11c\uc6b8\uc2dc \uc11c\ucd08\uad6c\",\"profileImageUrl\":\"https://cdn.example.com/profile2.jpg\",\"userType\":\"FOUNDER\"},\"category\":\"startup\",\"title\":\"\uc2a4\ud0c0\ud2b8\uc5c5 \uadfc\ubb34 \ud658\uacbd \uc120\ud638\ub3c4\",\"content\":\"\uc5b4\ub5a4 \uadfc\ubb34 \ud658\uacbd\uc744 \uc120\ud638\ud558\uc2dc\ub098\uc694? (\ubcf5\uc218 \uc120\ud0dd \uac00\ub2a5)\",\"images\":[],\"voteOptions\":[{\"id\":4,\"content\":\"\uc7ac\ud0dd\uadfc\ubb34\",\"sequence\":0,\"voteCount\":25,\"percentage\":50.0},{\"id\":5,\"content\":\"\uc0ac\ubb34\uc2e4 \uadfc\ubb34\",\"sequence\":1,\"voteCount\":15,\"percentage\":30.0},{\"id\":6,\"content\":\"\ud558\uc774\ube0c\ub9ac\ub4dc\",\"sequence\":2,\"voteCount\":10,\"percentage\":20.0}],\"hasVoted\":true,\"voteInfo\":{\"selectedOptionIds\":[4,6],\"totalVotes\":50,\"voteStatus\":\"IN_PROGRESS\",\"endTime\":\"2025-06-30T23:59:59\",\"allowRevote\":true,\"allowMultipleChoice\":true},\"viewCount\":350,\"commentCount\":25,\"likeCount\":42,\"isLiked\":true,\"isAuthorized\":true,\"isAuthor\":false,\"canEdit\":false,\"canDelete\":false,\"createdAt\":\"2025-01-05T14:00:00\",\"updatedAt\":\"2025-01-05T14:00:00\"}"), @ExampleObject(name="\ube44\uc778\uc99d \uc0ac\uc6a9\uc790", value="{\"postId\":1,\"author\":{\"userId\":\"author123\",\"nickname\":\"\uc791\uc131\uc790\",\"address\":\"\uc11c\uc6b8\uc2dc \uac15\ub0a8\uad6c\",\"profileImageUrl\":\"https://cdn.example.com/profile.jpg\",\"userType\":\"INHABITANT\"},\"category\":\"restaurant\",\"title\":\"\uc6b0\ub9ac \ub3d9\ub124 \uce74\ud398 \uc120\ud638\ub3c4 \uc870\uc0ac\",\"content\":\"\uc5ec\ub7ec\ubd84\uc774 \uac00\uc7a5 \uc88b\uc544\ud558\ub294 \uce74\ud398 \uc2a4\ud0c0\uc77c\uc740 \ubb34\uc5c7\uc778\uac00\uc694?\",\"images\":[],\"voteOptions\":[{\"id\":1,\"content\":\"\uc870\uc6a9\ud55c \ubd84\uc704\uae30\",\"sequence\":0,\"voteCount\":15,\"percentage\":37.5},{\"id\":2,\"content\":\"\ud65c\uae30\ucc2c \ubd84\uc704\uae30\",\"sequence\":1,\"voteCount\":10,\"percentage\":25.0},{\"id\":3,\"content\":\"\uc791\uc5c5\ud558\uae30 \uc88b\uc740 \uacf3\",\"sequence\":2,\"voteCount\":15,\"percentage\":37.5}],\"hasVoted\":null,\"voteInfo\":{\"selectedOptionIds\":[],\"totalVotes\":40,\"voteStatus\":\"IN_PROGRESS\",\"endTime\":\"2025-12-31T23:59:59\",\"allowRevote\":true,\"allowMultipleChoice\":false},\"viewCount\":120,\"commentCount\":5,\"likeCount\":8,\"isLiked\":null,\"isAuthorized\":false,\"isAuthor\":false,\"canEdit\":null,\"canDelete\":null,\"createdAt\":\"2025-01-01T10:00:00\",\"updatedAt\":\"2025-01-01T10:00:00\"}"), @ExampleObject(name="\ud22c\ud45c \uc644\ub8cc\ub41c \uac8c\uc2dc\uae00", value="{\"postId\":3,\"author\":{\"userId\":\"poll-master\",\"nickname\":\"\ud22c\ud45c\uc655\",\"address\":\"\uc11c\uc6b8\uc2dc \uc1a1\ud30c\uad6c\",\"profileImageUrl\":null,\"userType\":\"INHABITANT\"},\"category\":\"neighborhood-news\",\"title\":\"\ub3d9\ub124 \ucd95\uc81c \uac1c\ucd5c \uc2dc\uae30 \ud22c\ud45c\",\"content\":\"\uc5b8\uc81c \ucd95\uc81c\ub97c \uac1c\ucd5c\ud558\uba74 \uc88b\uc744\uae4c\uc694?\",\"images\":[],\"voteOptions\":[{\"id\":7,\"content\":\"\ubd04 (3-5\uc6d4)\",\"sequence\":0,\"voteCount\":30,\"percentage\":30.0},{\"id\":8,\"content\":\"\uc5ec\ub984 (6-8\uc6d4)\",\"sequence\":1,\"voteCount\":20,\"percentage\":20.0},{\"id\":9,\"content\":\"\uac00\uc744 (9-11\uc6d4)\",\"sequence\":2,\"voteCount\":50,\"percentage\":50.0}],\"hasVoted\":true,\"voteInfo\":{\"selectedOptionIds\":[9],\"totalVotes\":100,\"voteStatus\":\"COMPLETED\",\"endTime\":\"2025-01-10T23:59:59\",\"allowRevote\":false,\"allowMultipleChoice\":false},\"viewCount\":500,\"commentCount\":35,\"likeCount\":65,\"isLiked\":false,\"isAuthorized\":true,\"isAuthor\":false,\"canEdit\":false,\"canDelete\":false,\"createdAt\":\"2025-01-01T09:00:00\",\"updatedAt\":\"2025-01-01T09:00:00\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<VotesboardDetailResponse> getVotesboard(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        String userId = null;
        if (userDetails != null) {
            userId = userDetails.getUser().getId();
        }
        VotesboardDetailResponse response = this.votesboardService.getVotesboard(votesboardId, userId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping
    @Operation(operationId="getVotesboardsByCursor", summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c (\ucee4\uc11c \uae30\ubc18)", description="\ucee4\uc11c \uae30\ubc18 \ud398\uc774\uc9c0\ub124\uc774\uc158\uc73c\ub85c \ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\uc815\ub82c \uc635\uc158:**\n- LATEST: \ucd5c\uc2e0\uc21c (\uae30\ubcf8\uac12)\n- LIKE: \ud22c\ud45c\uc21c (\ud22c\ud45c \uc778\uc6d0 \ub9ce\uc740 \uc21c)\n- COMMENT: \ub313\uae00\uc21c\n- VIEW: \uc870\ud68c\uc21c\n\n**\ucee4\uc11c \uc0ac\uc6a9\ubc95:**\n\uccab \uc694\uccad: cursor \uc5c6\uc774 \uc694\uccad\n\ub2e4\uc74c \ud398\uc774\uc9c0: \uc774\uc804 \uc751\ub2f5\uc758 nextCursor \uac12\uc744 \uc0ac\uc6a9\n\n**\uc751\ub2f5 \ud544\ub4dc:**\n- contentPreview: \uac8c\uc2dc\uae00 \ub0b4\uc6a9 \ubbf8\ub9ac\ubcf4\uae30 (100\uc790 \uc81c\ud55c)\n- hasVoted: \ud604\uc7ac \uc0ac\uc6a9\uc790\uc758 \ud22c\ud45c \ucc38\uc5ec \uc5ec\ubd80 (\uc778\uc99d \uc0ac\uc6a9\uc790\ub9cc, \ube44\uc778\uc99d \uc2dc null)\n- isLiked: \ud604\uc7ac \uc0ac\uc6a9\uc790\uc758 \uc88b\uc544\uc694 \uc5ec\ubd80 (\uc778\uc99d \uc0ac\uc6a9\uc790\ub9cc, \ube44\uc778\uc99d \uc2dc null)\n- totalCount: \uc804\uccb4 \uac8c\uc2dc\uae00 \uc218 (\ud544\ud130 \uc801\uc6a9\ub41c \uacb0\uacfc)\n- isAuthorized: \uc694\uccad \uc0ac\uc6a9\uc790\uc758 \uc778\uc99d \uc5ec\ubd80\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotesboardCursorResponse.class))}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \ud30c\ub77c\ubbf8\ud130", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc798\ubabb\ub41c \uc815\ub82c \uac12", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'INVALID_SORT'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [LATEST, LIKE, COMMENT, VIEW]\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \ucee4\uc11c", value="{\"code\": \"INVALID_CURSOR\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ucee4\uc11c \uac12\uc785\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<VotesboardCursorResponse> getVotesboardList(@Parameter(description="\ud22c\ud45c \uc0c1\ud0dc (IN_PROGRESS: \uc9c4\ud589\uc911, COMPLETED: \uc644\ub8cc, null: \uc804\uccb4)") @RequestParam(required=false) VoteStatus status, @Parameter(description="\uc815\ub82c \uae30\uc900\n\n- LATEST: \ucd5c\uc2e0\uc21c (\uae30\ubcf8\uac12)\n- LIKE: \ud22c\ud45c\uc21c (\ud22c\ud45c \uc778\uc6d0 \ub9ce\uc740 \uc21c)\n- COMMENT: \ub313\uae00\uc21c\n- VIEW: \uc870\ud68c\uc21c\n", example="LATEST") @RequestParam(defaultValue="LATEST") VotesboardSortType sort, @Parameter(description="\ud398\uc774\uc9c0 \ud06c\uae30 (1-50, \uae30\ubcf8\uac12: 20)", example="20") @RequestParam(defaultValue="20") int size, @Parameter(description="\ucee4\uc11c \uae30\ubc18 \ud398\uc774\uc9d5\uc744 \uc704\ud55c \ucee4\uc11c \uac12\n\n**\uccab \uc694\uccad:** cursor \uc5c6\uc774 \uc694\uccad\n**\ub2e4\uc74c \ud398\uc774\uc9c0:** \uc774\uc804 \uc751\ub2f5\uc758 nextCursor \uac12 \uc0ac\uc6a9\n", example="42") @RequestParam(required=false) String cursor, @Parameter(hidden=true) @AuthenticationPrincipal CustomUserDetails userDetails) {
        String userId = null;
        if (userDetails != null) {
            userId = userDetails.getUser().getId();
        }
        VotesboardCursorResponse response = this.votesboardService.getVotesboardsByCursor(status, sort, size, cursor, userId);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{votesboardId}"}, consumes={"multipart/form-data"})
    @Operation(operationId="updateVotesboard", summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc218\uc815\ud569\ub2c8\ub2e4. \ud22c\ud45c \uc635\uc158\uc740 \uc218\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n\n**\uc218\uc815 \uac00\ub2a5 \ud56d\ubaa9:**\n- \uce74\ud14c\uace0\ub9ac\n- \uc81c\ubaa9, \ub0b4\uc6a9\n- \uc774\ubbf8\uc9c0 (\ucd94\uac00/\uc0ad\uc81c)\n- \ud22c\ud45c \uc124\uc815 (\ud22c\ud45c \uc2dc\uc791 \uc804\uc5d0\ub9cc \uac00\ub2a5)\n\n**Multipart \uc5c5\ub85c\ub4dc**\n", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=VotesboardUpdateRequest.class))}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c (\uc791\uc131\uc790\uac00 \uc544\ub2d8)", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED_ACCESS\", \"message\": \"\uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> updateVotesboard(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @ModelAttribute @Valid VotesboardUpdateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votesboardService.updateVotesboard(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{votesboardId}"})
    @Operation(operationId="deleteVotesboard", summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4 (\uc18c\ud504\ud2b8 \uc0ad\uc81c).")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c (\uc791\uc131\uc790\uac00 \uc544\ub2d8)", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED_ACCESS\", \"message\": \"\uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> deleteVotesboard(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votesboardService.deleteVotesboard(votesboardId, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{votesboardId}/vote"})
    @Operation(operationId="castVote", summary="\ud22c\ud45c \ucc38\uc5ec", description="\ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud569\ub2c8\ub2e4.\n\n**\uc81c\uc57d\uc0ac\ud56d:**\n- \ud55c \ud22c\ud45c\ub2f9 1\ubc88\ub9cc \ucc38\uc5ec \uac00\ub2a5 (\uc911\ubcf5 \ud22c\ud45c \ubd88\uac00)\n- \uc9c4\ud589 \uc911\uc778 \ud22c\ud45c\uc5d0\ub9cc \ucc38\uc5ec \uac00\ub2a5\n- \uc120\ud0dd\ud55c \uc635\uc158\uc740 \ud574\ub2f9 \ud22c\ud45c\uc758 \uc635\uc158\uc774\uc5b4\uc57c \ud568\n\n**\ub2e8\uc77c \uc120\ud0dd \ud22c\ud45c (allowMultipleChoice = false):**\n- \uc815\ud655\ud788 1\uac1c\uc758 \uc635\uc158\ub9cc \uc120\ud0dd \uac00\ub2a5\n- \uc608: voteOptionIds: [1]\n\n**\uc911\ubcf5 \uc120\ud0dd \ud22c\ud45c (allowMultipleChoice = true):**\n- \ucd5c\uc18c 1\uac1c, \ucd5c\ub300 n-1\uac1c \uc120\ud0dd \uac00\ub2a5 (n = \uc804\uccb4 \uc635\uc158 \uc218)\n- \uc608: \uc635\uc158\uc774 5\uac1c\uc77c \ub54c, 1~4\uac1c\uae4c\uc9c0 \uc120\ud0dd \uac00\ub2a5\n- \uc608: voteOptionIds: [1, 2, 3]\n\n**\uad8c\ud55c:** \ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub9cc \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ucc38\uc5ec \uc131\uacf5"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \ub9c8\uac10", value="{\"code\": \"VOTE_CLOSED\", \"message\": \"\ud22c\ud45c\uac00 \ub9c8\uac10\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uc635\uc158", value="{\"code\": \"INVALID_VOTE_OPTION\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud22c\ud45c \uc635\uc158\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="409", description="\uc774\ubbf8 \ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud568", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc911\ubcf5 \ud22c\ud45c", value="{\"code\": \"ALREADY_VOTED\", \"message\": \"\uc774\ubbf8 \ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud558\uc600\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00 \ub610\ub294 \uc635\uc158\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uac8c\uc2dc\uae00 \uc5c6\uc74c", value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> vote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true, example="1") @PathVariable Long votesboardId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="\ud22c\ud45c \uc635\uc158 \uc120\ud0dd \uc815\ubcf4", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=VoteRequest.class), examples={@ExampleObject(name="\ub2e8\uc77c \uc120\ud0dd", value="{\"voteOptionIds\": [1]}", description="allowMultipleChoice = false\uc778 \uacbd\uc6b0"), @ExampleObject(name="\uc911\ubcf5 \uc120\ud0dd", value="{\"voteOptionIds\": [1, 2, 3]}", description="allowMultipleChoice = true\uc778 \uacbd\uc6b0")})}) @Valid @RequestBody VoteRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votesboardService.vote(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{votesboardId}/vote"})
    @Operation(operationId="changeVote", summary="\ud22c\ud45c \ubcc0\uacbd (\uc7ac\ud22c\ud45c)", description="\uc774\ubbf8 \ucc38\uc5ec\ud55c \ud22c\ud45c\ub97c \ubcc0\uacbd\ud569\ub2c8\ub2e4.\n\n**\uc81c\uc57d\uc0ac\ud56d:**\n- \uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub41c \uacbd\uc6b0\uc5d0\ub9cc \uac00\ub2a5 (allowRevote = true)\n- \uc9c4\ud589 \uc911\uc778 \ud22c\ud45c\uc5d0\ub9cc \uac00\ub2a5\n- \uae30\uc874\uc5d0 \ud22c\ud45c\ud55c \uae30\ub85d\uc774 \uc788\uc5b4\uc57c \ud568\n\n**\ub2e8\uc77c \uc120\ud0dd \ud22c\ud45c (allowMultipleChoice = false):**\n- \uc815\ud655\ud788 1\uac1c\uc758 \uc635\uc158\ub9cc \uc120\ud0dd \uac00\ub2a5\n- \uc608: \uc635\uc158 1 \u2192 \uc635\uc158 2\ub85c \ubcc0\uacbd\n\n**\uc911\ubcf5 \uc120\ud0dd \ud22c\ud45c (allowMultipleChoice = true):**\n- \ucd5c\uc18c 1\uac1c, \ucd5c\ub300 n-1\uac1c \uc120\ud0dd \uac00\ub2a5\n- \uc608: [1, 2] \u2192 [2, 3, 4]\ub85c \ubcc0\uacbd\n\n**\uad8c\ud55c:** \ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub9cc \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ubcc0\uacbd \uc131\uacf5"), @ApiResponse(responseCode="400", description="\ud22c\ud45c \ub9c8\uac10", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \ub9c8\uac10", value="{\"code\": \"VOTE_CLOSED\", \"message\": \"\ud22c\ud45c\uac00 \ub9c8\uac10\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uc7ac\ud22c\ud45c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc7ac\ud22c\ud45c \ubd88\uac00", value="{\"code\": \"REVOTE_NOT_ALLOWED\", \"message\": \"\uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \uae30\ub85d \uc5c6\uc74c", value="{\"code\": \"VOTE_NOT_FOUND\", \"message\": \"\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> changeVote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true, example="1") @PathVariable Long votesboardId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc0c8\ub85c \uc120\ud0dd\ud560 \ud22c\ud45c \uc635\uc158 \uc815\ubcf4", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=VoteRequest.class), examples={@ExampleObject(name="\ub2e8\uc77c \uc120\ud0dd \ubcc0\uacbd", value="{\"voteOptionIds\": [3]}", description="\uc635\uc158 1 \u2192 \uc635\uc158 3\uc73c\ub85c \ubcc0\uacbd"), @ExampleObject(name="\uc911\ubcf5 \uc120\ud0dd \ubcc0\uacbd", value="{\"voteOptionIds\": [2, 3, 4]}", description="[1, 2] \u2192 [2, 3, 4]\ub85c \ubcc0\uacbd")})}) @Valid @RequestBody VoteRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votesboardService.changeVote(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{votesboardId}/vote"})
    @Operation(operationId="cancelVote", summary="\ud22c\ud45c \ucde8\uc18c", description="\ucc38\uc5ec\ud55c \ud22c\ud45c\ub97c \ucde8\uc18c\ud569\ub2c8\ub2e4. \uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub41c \uacbd\uc6b0\uc5d0\ub9cc \uac00\ub2a5\ud569\ub2c8\ub2e4.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ucde8\uc18c \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uc7ac\ud22c\ud45c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"REVOTE_NOT_ALLOWED\", \"message\": \"\uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"VOTE_NOT_FOUND\", \"message\": \"\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> cancelVote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votesboardService.cancelVote(votesboardId, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @Generated
    public VotesboardController(VotesboardService votesboardService) {
        this.votesboardService = votesboardService;
    }
}

