/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.s3;

import com.example.soso.global.s3.ImageResizeUtil;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

@Service
public class S3Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Service.class);
    private final S3Client s3;
    @Value(value="${spring.cloud.aws.s3.bucket}")
    private String bucket;
    @Value(value="${spring.cloud.aws.s3.base-url}")
    private String baseUrl;

    @PostConstruct
    private void normalizeBaseUrl() {
        this.baseUrl = this.trimTrailingSlashes(this.baseUrl);
    }

    public String uploadImage(MultipartFile file, String dir) {
        try {
            byte[] resized = ImageResizeUtil.resizeToJpg((MultipartFile)file);
            String key = dir + "/" + String.valueOf(UUID.randomUUID()) + ".jpg";
            PutObjectRequest put = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(key).contentType("image/jpeg").build();
            this.s3.putObject(put, RequestBody.fromBytes((byte[])resized));
            return this.buildObjectUrl(key);
        }
        catch (IOException e) {
            log.error("S3 \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc2e4\ud328", (Throwable)e);
            throw new RuntimeException("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }

    public void deleteImage(String imageUrl) {
        if (!(this.hasText(this.baseUrl) && this.hasText(imageUrl) && imageUrl.startsWith(this.baseUrl + "/"))) {
            log.warn("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc774\ubbf8\uc9c0 URL\ub85c \uc0ad\uc81c \uc694\uccad: {}", (Object)imageUrl);
            return;
        }
        String key = this.extractKeyFromUrl(imageUrl);
        try {
            this.s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(key).build());
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                log.warn("\uc0ad\uc81c \uc2e4\ud328: \uac1d\uccb4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c - {}", (Object)key);
            }
            throw e;
        }
    }

    public boolean isImageExists(String imageUrl) {
        if (!(this.hasText(this.baseUrl) && this.hasText(imageUrl) && imageUrl.startsWith(this.baseUrl + "/"))) {
            return false;
        }
        String key = this.extractKeyFromUrl(imageUrl);
        try {
            this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(key).build());
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private String extractKeyFromUrl(String url) {
        if (!this.hasText(url) || !this.hasText(this.baseUrl)) {
            return url;
        }
        String prefix = this.baseUrl + "/";
        if (!url.startsWith(prefix)) {
            return url;
        }
        return url.substring(prefix.length());
    }

    private String buildObjectUrl(String key) {
        return this.baseUrl + "/" + key;
    }

    private String trimTrailingSlashes(String value) {
        int end;
        if (value == null) {
            return null;
        }
        for (end = value.length(); end > 0 && value.charAt(end - 1) == '/'; --end) {
        }
        return value.substring(0, end);
    }

    private boolean hasText(String value) {
        return value != null && !value.trim().isEmpty();
    }

    @Generated
    public S3Service(S3Client s3) {
        this.s3 = s3;
    }
}

