/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.sigungu.config;

import com.example.soso.sigungu.domain.entity.SigunguCode;
import com.example.soso.sigungu.repository.SigunguCodeRepository;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SigunguCodeDataLoader
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigunguCodeDataLoader.class);
    private final SigunguCodeRepository sigunguCodeRepository;
    private static final String CSV_FILE_PATH = "data/sigunguCode.csv";

    @Transactional
    public void run(String ... args) throws Exception {
        long count = this.sigunguCodeRepository.count();
        if (count > 0L) {
            log.info("\uc2dc\uad70\uad6c \ucf54\ub4dc \ub370\uc774\ud130\uac00 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4. (\ucd1d {}\uac74) \ub85c\ub4dc\ub97c \uac74\ub108\ub701\ub2c8\ub2e4.", (Object)count);
            return;
        }
        log.info("\uc2dc\uad70\uad6c \ucf54\ub4dc CSV \ud30c\uc77c \ub85c\ub4dc \uc2dc\uc791: {}", (Object)CSV_FILE_PATH);
        try {
            ClassPathResource resource = new ClassPathResource(CSV_FILE_PATH);
            ArrayList<SigunguCode> sigunguCodes = new ArrayList<SigunguCode>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                String headerLine = reader.readLine();
                log.debug("CSV \ud5e4\ub354: {}", (Object)headerLine);
                int lineNumber = 1;
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    if (line.trim().isEmpty()) continue;
                    try {
                        SigunguCode sigunguCode = this.parseCsvLine(line);
                        sigunguCodes.add(sigunguCode);
                    }
                    catch (Exception e) {
                        log.warn("CSV \ub77c\uc778 {} \ud30c\uc2f1 \uc2e4\ud328: {} - \uc5d0\ub7ec: {}", new Object[]{lineNumber, line, e.getMessage()});
                    }
                }
            }
            if (!sigunguCodes.isEmpty()) {
                this.sigunguCodeRepository.saveAll(sigunguCodes);
                log.info("\uc2dc\uad70\uad6c \ucf54\ub4dc \ub370\uc774\ud130 \ub85c\ub4dc \uc644\ub8cc: \ucd1d {}\uac74", (Object)sigunguCodes.size());
            } else {
                log.warn("\ub85c\ub4dc\ud560 \uc2dc\uad70\uad6c \ucf54\ub4dc \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            log.error("\uc2dc\uad70\uad6c \ucf54\ub4dc CSV \ud30c\uc77c \ub85c\ub4dc \uc2e4\ud328: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private SigunguCode parseCsvLine(String line) {
        String[] parts = line.split(",", -1);
        if (parts.length != 4) {
            throw new IllegalArgumentException("\uc798\ubabb\ub41c CSV \ud615\uc2dd: " + line);
        }
        String code = parts[0].trim();
        String sido = parts[1].trim();
        String sigungu = parts[2].trim();
        String fullName = parts[3].trim();
        if (!SigunguCode.isValidCode((String)code)) {
            throw new IllegalArgumentException("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc2dc\uad70\uad6c \ucf54\ub4dc: " + code);
        }
        return SigunguCode.builder().code(code).sido(sido).sigungu(sigungu).fullName(fullName).build();
    }

    @Generated
    public SigunguCodeDataLoader(SigunguCodeRepository sigunguCodeRepository) {
        this.sigunguCodeRepository = sigunguCodeRepository;
    }
}

