/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.post.domain.entity;

import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.domain.entity.PostImage;
import com.example.soso.global.time.BaseTimeEntity;
import com.example.soso.users.domain.entity.Users;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
public class Post
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    private Users user;
    @Enumerated(value=EnumType.STRING)
    private Category category;
    @OneToMany(mappedBy="post", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PostImage> images;
    private String title;
    @Lob
    private String content;
    private int likeCount;
    private int commentCount;
    @Column(nullable=false)
    private int viewCount;
    @Column(nullable=false)
    private boolean deleted;

    public void delete() {
        this.deleted = true;
    }

    public void addImage(PostImage image) {
        this.images.add(image);
        image.setPost(this);
    }

    public void update(String title, String content, Category category, List<PostImage> newImages) {
        if (title != null) {
            this.title = title;
        }
        if (content != null) {
            this.content = content;
        }
        if (category != null) {
            this.category = category;
        }
        if (newImages != null && !newImages.isEmpty()) {
            this.images = newImages;
        }
    }

    public void updateLikeCount(int redisLikeCount) {
        this.likeCount = redisLikeCount;
    }

    public void updateCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    public void increaseViewCount() {
        ++this.viewCount;
    }

    public LocalDateTime getCreatedAt() {
        return super.getCreatedAt();
    }

    public LocalDateTime getUpdatedAt() {
        return super.getUpdatedAt();
    }

    @Generated
    private static List<PostImage> $default$images() {
        return new ArrayList<PostImage>();
    }

    @Generated
    private static int $default$viewCount() {
        return 0;
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    public static PostBuilder builder() {
        return new PostBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Users getUser() {
        return this.user;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public List<PostImage> getImages() {
        return this.images;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public int getLikeCount() {
        return this.likeCount;
    }

    @Generated
    public int getCommentCount() {
        return this.commentCount;
    }

    @Generated
    public int getViewCount() {
        return this.viewCount;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    protected Post() {
        this.images = Post.$default$images();
        this.viewCount = Post.$default$viewCount();
        this.deleted = Post.$default$deleted();
    }

    @Generated
    private Post(Long id, Users user, Category category, List<PostImage> images, String title, String content, int likeCount, int commentCount, int viewCount, boolean deleted) {
        this.id = id;
        this.user = user;
        this.category = category;
        this.images = images;
        this.title = title;
        this.content = content;
        this.likeCount = likeCount;
        this.commentCount = commentCount;
        this.viewCount = viewCount;
        this.deleted = deleted;
    }
}

