/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.service;

import com.example.soso.community.common.comment.domain.entity.Comment;
import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.CommentErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.CommentException;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public abstract class AbstractCommentService<T, R, U, S> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCommentService.class);
    protected final CommentRepository commentRepository;
    protected final PostRepository postRepository;
    protected final UsersRepository usersRepository;

    @Transactional
    public R createComment(T request, String userId, Long postId) {
        log.info("\ub313\uae00 \uc791\uc131 \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = this.findPostById(postId);
        Users user = this.findUserById(userId);
        this.validateCommentContent(this.getContent(request));
        Comment parentComment = null;
        if (this.getParentId(request) != null) {
            parentComment = this.findCommentById(this.getParentId(request));
            this.validateReplyDepth(parentComment);
        }
        Comment comment = Comment.builder().post(post).user(user).parent(parentComment).content(this.getContent(request)).build();
        Comment savedComment = (Comment)this.commentRepository.save((Object)comment);
        this.updatePostCommentCount(post);
        log.info("\ub313\uae00 \uc791\uc131 \uc644\ub8cc: commentId={}", (Object)savedComment.getId());
        return (R)this.buildCreateResponse(savedComment.getId());
    }

    @Transactional(readOnly=true)
    public U getCommentsByCursor(Long postId, S sortType, int size, String cursor, String userId) {
        boolean hasNext;
        log.info("\ub313\uae00 \ubaa9\ub85d \uc870\ud68c: postId={}, sortType={}, size={}, userId={}", new Object[]{postId, sortType, size, userId});
        this.findPostById(postId);
        size = Math.max(1, Math.min(50, size));
        Sort sort = this.buildSort(sortType);
        PageRequest pageable = PageRequest.of((int)0, (int)(size + 1), (Sort)sort);
        LocalDateTime cursorTime = this.parseCursor(cursor);
        List comments = this.fetchComments(postId, cursorTime, (Pageable)pageable, sortType);
        boolean bl = hasNext = comments.size() > size;
        if (hasNext) {
            comments.remove(comments.size() - 1);
        }
        String nextCursor = hasNext && !comments.isEmpty() ? this.generateCursor((Comment)comments.get(comments.size() - 1)) : null;
        return (U)this.buildCursorResponse(comments, hasNext, nextCursor, size, userId);
    }

    @Transactional
    public R updateComment(Long commentId, Object request, String userId) {
        log.info("\ub313\uae00 \uc218\uc815 \uc2dc\uc791: commentId={}, userId={}", (Object)commentId, (Object)userId);
        Comment comment = this.findCommentByIdAndUserId(commentId, userId);
        String content = this.getUpdateContent(request);
        this.validateCommentContent(content);
        comment.updateContent(content);
        log.info("\ub313\uae00 \uc218\uc815 \uc644\ub8cc: commentId={}", (Object)commentId);
        return (R)this.buildCreateResponse(commentId);
    }

    @Transactional
    public void deleteComment(Long commentId, String userId) {
        log.info("\ub313\uae00 \uc0ad\uc81c \uc2dc\uc791: commentId={}, userId={}", (Object)commentId, (Object)userId);
        Comment comment = this.findCommentByIdAndUserId(commentId, userId);
        comment.delete();
        this.updatePostCommentCount(comment.getPost());
        log.info("\ub313\uae00 \uc0ad\uc81c \uc644\ub8cc: commentId={}", (Object)commentId);
    }

    protected abstract String getContent(T var1);

    protected abstract Long getParentId(T var1);

    protected abstract R buildCreateResponse(Long var1);

    protected abstract U buildCursorResponse(List<Comment> var1, boolean var2, String var3, int var4, String var5);

    protected abstract Sort buildSort(S var1);

    protected abstract List<Comment> fetchComments(Long var1, LocalDateTime var2, Pageable var3, S var4);

    protected String getUpdateContent(Object request) {
        try {
            return (String)request.getClass().getMethod("getContent", new Class[0]).invoke(request, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get content from update request", e);
        }
    }

    protected Post findPostById(Long postId) {
        return (Post)this.postRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
    }

    protected Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    protected Comment findCommentById(Long commentId) {
        return (Comment)this.commentRepository.findByIdAndDeletedFalse(commentId).orElseThrow(() -> new CommentException(CommentErrorCode.COMMENT_NOT_FOUND));
    }

    protected Comment findCommentByIdAndUserId(Long commentId, String userId) {
        Comment comment = this.findCommentById(commentId);
        if (!comment.getUser().getId().equals(userId)) {
            throw new CommentException(CommentErrorCode.COMMENT_ACCESS_DENIED);
        }
        return comment;
    }

    protected void validateCommentContent(String content) {
        if (!StringUtils.hasText((String)content)) {
            throw new CommentException(CommentErrorCode.COMMENT_CONTENT_EMPTY);
        }
        if (content.trim().length() > 1000) {
            throw new CommentException(CommentErrorCode.COMMENT_CONTENT_TOO_LONG);
        }
    }

    protected void validateReplyDepth(Comment parentComment) {
        if (parentComment.getParent() != null) {
            throw new CommentException(CommentErrorCode.REPLY_DEPTH_EXCEEDED);
        }
    }

    protected void updatePostCommentCount(Post post) {
        int commentCount = this.commentRepository.countByPostIdAndDeletedFalse(post.getId());
        post.updateCommentCount(commentCount);
    }

    protected LocalDateTime parseCursor(String cursor) {
        if (!StringUtils.hasText((String)cursor)) {
            return null;
        }
        try {
            String decodedCursor = new String(Base64.getDecoder().decode(cursor));
            return LocalDateTime.parse(decodedCursor, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (Exception e) {
            log.warn("\uc798\ubabb\ub41c \ucee4\uc11c \ud615\uc2dd: {}", (Object)cursor);
            return null;
        }
    }

    protected String generateCursor(Comment comment) {
        String timestamp = comment.getCreatedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        return Base64.getEncoder().encodeToString(timestamp.getBytes());
    }

    @Generated
    public AbstractCommentService(CommentRepository commentRepository, PostRepository postRepository, UsersRepository usersRepository) {
        this.commentRepository = commentRepository;
        this.postRepository = postRepository;
        this.usersRepository = usersRepository;
    }
}

