/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.freeboard.comment.service;

import com.example.soso.community.common.comment.domain.entity.Comment;
import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.common.likes.repository.CommentLikeRepository;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.community.common.service.AbstractCommentService;
import com.example.soso.community.freeboard.comment.domain.dto.FreeboardCommentCreateRequest;
import com.example.soso.community.freeboard.comment.domain.dto.FreeboardCommentCreateResponse;
import com.example.soso.community.freeboard.comment.domain.dto.FreeboardCommentCursorResponse;
import com.example.soso.community.freeboard.comment.domain.dto.FreeboardCommentSortType;
import com.example.soso.community.freeboard.comment.domain.dto.FreeboardCommentUpdateRequest;
import com.example.soso.community.freeboard.comment.service.FreeboardCommentService;
import com.example.soso.community.freeboard.comment.service.FreeboardCommentServiceImpl;
import com.example.soso.users.repository.UsersRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FreeboardCommentServiceImpl
extends AbstractCommentService<FreeboardCommentCreateRequest, FreeboardCommentCreateResponse, FreeboardCommentCursorResponse, FreeboardCommentSortType>
implements FreeboardCommentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FreeboardCommentServiceImpl.class);
    private final CommentLikeRepository commentLikeRepository;

    public FreeboardCommentServiceImpl(CommentRepository commentRepository, PostRepository postRepository, UsersRepository usersRepository, CommentLikeRepository commentLikeRepository) {
        super(commentRepository, postRepository, usersRepository);
        this.commentLikeRepository = commentLikeRepository;
    }

    @Transactional
    public FreeboardCommentCreateResponse createComment(Long postId, FreeboardCommentCreateRequest request, String userId) {
        return (FreeboardCommentCreateResponse)super.createComment((Object)request, userId, postId);
    }

    public FreeboardCommentCursorResponse getCommentsByCursor(Long postId, FreeboardCommentSortType sort, int size, String cursor, String userId) {
        return (FreeboardCommentCursorResponse)super.getCommentsByCursor(postId, (Object)sort, size, cursor, userId);
    }

    @Transactional
    public FreeboardCommentCreateResponse updateComment(Long postId, Long commentId, FreeboardCommentUpdateRequest request, String userId) {
        return (FreeboardCommentCreateResponse)super.updateComment(commentId, (Object)request, userId);
    }

    @Transactional
    public void deleteComment(Long postId, Long commentId, String userId) {
        super.deleteComment(commentId, userId);
    }

    @Transactional
    public void hardDeleteComment(Long postId, Long commentId, String userId) {
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \ub313\uae00 \ud558\ub4dc \uc0ad\uc81c \uc2dc\uc791: postId={}, commentId={}, userId={}", new Object[]{postId, commentId, userId});
        Comment comment = this.findCommentByIdAndUserId(commentId, userId);
        List childComments = this.commentRepository.findByParentId(commentId);
        int totalDeletedCount = childComments.size() + 1;
        this.commentRepository.delete((Object)comment);
        Post post = comment.getPost();
        post.updateCommentCount(Math.max(0, post.getCommentCount() - totalDeletedCount));
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \ub313\uae00 \ud558\ub4dc \uc0ad\uc81c \uc644\ub8cc: commentId={}, deletedChildCount={}", (Object)commentId, (Object)childComments.size());
    }

    protected String getContent(FreeboardCommentCreateRequest request) {
        return request.getContent();
    }

    protected Long getParentId(FreeboardCommentCreateRequest request) {
        return request.getParentCommentId();
    }

    protected FreeboardCommentCreateResponse buildCreateResponse(Long commentId) {
        return new FreeboardCommentCreateResponse(commentId);
    }

    protected FreeboardCommentCursorResponse buildCursorResponse(List<Comment> comments, boolean hasNext, String nextCursor, int size, String userId) {
        List<FreeboardCommentCursorResponse.FreeboardCommentSummary> summaries = comments.stream().map(comment -> this.createCommentSummary(comment, userId)).toList();
        long total = 0L;
        if (!comments.isEmpty()) {
            Long postId = comments.get(0).getPost().getId();
            total = this.commentRepository.countByPostId(postId);
        }
        return FreeboardCommentCursorResponse.builder().comments(summaries).hasNext(hasNext).nextCursor(nextCursor).size(summaries.size()).total(total).isAuthorized(userId != null).build();
    }

    protected Sort buildSort(FreeboardCommentSortType sortType) {
        return switch (1.$SwitchMap$com$example$soso$community$freeboard$comment$domain$dto$FreeboardCommentSortType[sortType.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"});
            case 2 -> Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createdAt"});
        };
    }

    protected List<Comment> fetchComments(Long postId, LocalDateTime cursorTime, Pageable pageable, FreeboardCommentSortType sortType) {
        if (cursorTime == null) {
            return this.commentRepository.findByPostId(postId, pageable);
        }
        if (sortType == FreeboardCommentSortType.LATEST) {
            return this.commentRepository.findByPostIdAndCreatedAtBefore(postId, cursorTime, pageable);
        }
        return this.commentRepository.findByPostIdAndCreatedAtAfter(postId, cursorTime, pageable);
    }

    private FreeboardCommentCursorResponse.FreeboardCommentSummary createCommentSummary(Comment comment, String userId) {
        int replyCount = this.commentRepository.countByParentIdAndDeletedFalse(comment.getId());
        int depth = comment.getParent() != null ? 1 : 0;
        int likeCount = this.commentLikeRepository.countByComment_Id(comment.getId());
        boolean isAuthorized = userId != null;
        boolean isAuthor = userId != null && comment.getUser().getId().equals(userId);
        Boolean isLiked = isAuthorized ? Boolean.valueOf(this.commentLikeRepository.existsByComment_IdAndUser_Id(comment.getId(), userId)) : null;
        Boolean canEdit = isAuthorized ? Boolean.valueOf(isAuthor) : null;
        Boolean canDelete = isAuthorized ? Boolean.valueOf(isAuthor) : null;
        return FreeboardCommentCursorResponse.FreeboardCommentSummary.builder().commentId(comment.getId()).postId(comment.getPost().getId()).parentCommentId(comment.getParent() != null ? comment.getParent().getId() : null).author(FreeboardCommentCursorResponse.CommentAuthorInfo.builder().userId(comment.getUser().getId()).nickname(comment.getUser().getNickname()).profileImageUrl(comment.getUser().getProfileImageUrl()).userType(comment.getUser().getUserType()).build()).content(comment.isDeleted() ? "\uc0ad\uc81c\ub41c \ub313\uae00\uc785\ub2c8\ub2e4." : comment.getContent()).replyCount(replyCount).likeCount(likeCount).depth(depth).deleted(comment.isDeleted()).isAuthor(isAuthor).isLiked(isLiked).canEdit(canEdit).canDelete(canDelete).createdAt(comment.getCreatedAt()).updatedAt(comment.getUpdatedAt()).build();
    }
}

