/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.domain.dto;

import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.votesboard.domain.dto.VoteInfo;
import com.example.soso.community.votesboard.domain.dto.VoteOptionResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardCreateRequest;
import com.example.soso.community.votesboard.domain.dto.VotesboardCursorResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardDetailResponse;
import com.example.soso.community.votesboard.domain.dto.VotesboardSummary;
import com.example.soso.community.votesboard.domain.entity.VoteOption;
import com.example.soso.community.votesboard.domain.entity.VoteResult;
import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.domain.entity.VotesboardImage;
import com.example.soso.users.domain.dto.UserMapper;
import com.example.soso.users.domain.entity.Users;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class VotesboardMapper {
    private final UserMapper userMapper;

    public Votesboard toEntity(VotesboardCreateRequest request, Users user) {
        Votesboard votesboard = Votesboard.create((Users)user, (String)request.getTitle(), (String)request.getContent(), (Category)request.getCategory(), (LocalDateTime)request.getEndTime(), (boolean)request.getAllowRevote(), (boolean)request.getAllowMultipleChoice());
        List<VoteOption> options = request.getVoteOptions().stream().map(optionRequest -> VoteOption.builder().votesboard(votesboard).content(optionRequest.getContent()).sequence(request.getVoteOptions().indexOf(optionRequest)).build()).toList();
        votesboard.addVoteOptions(options);
        return votesboard;
    }

    public VotesboardSummary toSummaryResponse(Votesboard votesboard, long commentCount, long likeCount, Boolean isLiked, Boolean hasVoted) {
        List<VoteOptionResponse> voteOptions = votesboard.getVoteOptions().stream().limit(3L).map(option -> this.toVoteOptionResponse(option, votesboard.getTotalVotes())).toList();
        List images = votesboard.getImages();
        String thumbnailUrl = images.isEmpty() ? null : (String)images.stream().sorted((img1, img2) -> Integer.compare(img1.getSequence(), img2.getSequence())).findFirst().map(VotesboardImage::getImageUrl).orElse(null);
        int imageCount = images.size();
        String contentPreview = votesboard.getContent() != null && votesboard.getContent().length() > 100 ? votesboard.getContent().substring(0, 100) + "..." : votesboard.getContent();
        VoteInfo voteInfo = new VoteInfo(List.of(), votesboard.getTotalVotes(), votesboard.getVoteStatus(), votesboard.getEndTime(), votesboard.isAllowRevote(), votesboard.isAllowMultipleChoice());
        return VotesboardSummary.builder().postId(votesboard.getId()).author(this.userMapper.toUserSummary(votesboard.getUser())).category(votesboard.getCategory()).title(votesboard.getTitle()).contentPreview(contentPreview).thumbnailUrl(thumbnailUrl).imageCount(imageCount).viewCount(votesboard.getViewCount()).commentCount(commentCount).hasVoted(hasVoted).voteInfo(voteInfo).voteOptions(voteOptions).likeCount(likeCount).isLiked(isLiked).createdAt(votesboard.getCreatedAt()).updatedAt(votesboard.getUpdatedAt()).build();
    }

    public VotesboardDetailResponse toDetailResponse(Votesboard votesboard, long commentCount, List<VoteResult> userVoteResults, long likeCount, Boolean isLiked, String userId) {
        List selectedOptionIds;
        boolean isAuthorized = userId != null;
        boolean isAuthor = userId != null && votesboard.getUser().getId().equals(userId);
        List<Object> list = selectedOptionIds = userVoteResults != null ? userVoteResults.stream().map(vr -> vr.getVoteOption().getId()).toList() : List.of();
        Boolean hasVoted = userId != null ? Boolean.valueOf(userVoteResults != null && !userVoteResults.isEmpty()) : null;
        List<VotesboardDetailResponse.ImageInfo> images = votesboard.getImages().stream().sorted((img1, img2) -> Integer.compare(img1.getSequence(), img2.getSequence())).map(img -> VotesboardDetailResponse.ImageInfo.builder().imageId(img.getId()).imageUrl(img.getImageUrl()).sequence(img.getSequence()).build()).toList();
        VoteInfo voteInfo = new VoteInfo(selectedOptionIds, votesboard.getTotalVotes(), votesboard.getVoteStatus(), votesboard.getEndTime(), votesboard.isAllowRevote(), votesboard.isAllowMultipleChoice());
        return VotesboardDetailResponse.builder().postId(votesboard.getId()).author(this.userMapper.toUserSummary(votesboard.getUser())).category(votesboard.getCategory()).title(votesboard.getTitle()).content(votesboard.getContent()).images(images).voteOptions(votesboard.getVoteOptions().stream().map(option -> this.toVoteOptionResponse(option, votesboard.getTotalVotes())).toList()).hasVoted(hasVoted).voteInfo(voteInfo).viewCount(votesboard.getViewCount()).commentCount(commentCount).likeCount(likeCount).isLiked(isLiked).isAuthorized(isAuthorized).isAuthor(isAuthor).canEdit(isAuthorized ? Boolean.valueOf(isAuthor) : null).canDelete(isAuthorized ? Boolean.valueOf(isAuthor) : null).createdAt(votesboard.getCreatedAt()).updatedAt(votesboard.getUpdatedAt()).build();
    }

    public VoteOptionResponse toVoteOptionResponse(VoteOption option, int totalVotes) {
        return VoteOptionResponse.builder().id(option.getId()).content(option.getContent()).sequence(option.getSequence()).voteCount(option.getVoteCount()).percentage(option.calculatePercentage(totalVotes)).build();
    }

    public VotesboardCursorResponse toListResponse(List<VotesboardSummary> posts, String nextCursor, boolean hasNext, long totalCount, boolean isAuthorized) {
        return VotesboardCursorResponse.builder().posts(posts).hasNext(hasNext).nextCursor(nextCursor).size(posts.size()).totalCount(totalCount).isAuthorized(isAuthorized).build();
    }

    @Generated
    public VotesboardMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }
}

