/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.scheduler;

import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.global.redis.PostLikeRedisRepository;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PostLikeSyncScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostLikeSyncScheduler.class);
    private final PostLikeRedisRepository redisRepository;
    private final PostRepository postRepository;

    @Scheduled(cron="0 0 1 * * *")
    public void syncLikeCountToDatabase() {
        log.info("[Scheduler] \uac8c\uc2dc\uae00 \uc88b\uc544\uc694 \uc218 \ub3d9\uae30\ud654 \uc2dc\uc791");
        Set postIds = this.redisRepository.getAllPostIdsWithLikes();
        for (Long postId : postIds) {
            long redisLikeCount = this.redisRepository.getLikeCount(postId);
            this.postRepository.findById((Object)postId).ifPresent(post -> {
                post.updateLikeCount((int)redisLikeCount);
                log.info("\uac8c\uc2dc\uae00 {} - \uc88b\uc544\uc694 \uc218 {} \ubc18\uc601 \uc644\ub8cc", (Object)postId, (Object)redisLikeCount);
            });
        }
        log.info("[Scheduler] \uac8c\uc2dc\uae00 \uc88b\uc544\uc694 \uc218 \ub3d9\uae30\ud654 \uc644\ub8cc");
    }

    @Generated
    public PostLikeSyncScheduler(PostLikeRedisRepository redisRepository, PostRepository postRepository) {
        this.redisRepository = redisRepository;
        this.postRepository = postRepository;
    }
}

