/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.controller;

import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.users.domain.dto.AgeRangeRequest;
import com.example.soso.users.domain.dto.BudgetRequest;
import com.example.soso.users.domain.dto.ExperienceRequest;
import com.example.soso.users.domain.dto.GenderRequest;
import com.example.soso.users.domain.dto.RegionRequest;
import com.example.soso.users.domain.dto.SignupCompleteResponse;
import com.example.soso.users.domain.dto.UserTypeRequest;
import com.example.soso.users.domain.entity.InterestRequest;
import com.example.soso.users.domain.entity.SignupStep;
import com.example.soso.users.service.SignupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Signup", description="**\ud68c\uc6d0\uac00\uc785 \ub2e8\uacc4\ubcc4 API**\n\n**\uc804\uc81c\uc870\uac74**: \uce74\uce74\uc624 \ub85c\uadf8\uc778 \ud6c4 \ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \uc0dd\uc131\ub418\uc5b4 \uc788\uc5b4\uc57c \ud569\ub2c8\ub2e4.\n\n**\ud50c\ub85c\uc6b0**:\n- **\uc608\ube44\ucc3d\uc5c5\uc790(FOUNDER)**: user-type \u2192 region \u2192 age-range \u2192 gender \u2192 interests \u2192 budget \u2192 experience \u2192 nickname \u2192 complete\n- **\uc77c\ubc18\uac70\uc8fc\ubbfc(INHABITANT)**: user-type \u2192 region \u2192 age-range \u2192 gender \u2192 nickname \u2192 complete\n\n\uac01 \ub2e8\uacc4\ub294 \uc21c\uc11c\ub300\ub85c \uc9c4\ud589\ub418\uc5b4\uc57c \ud558\uba70, \uc774\uc804 \ub2e8\uacc4\uac00 \uc644\ub8cc\ub418\uc9c0 \uc54a\uc73c\uba74 \ub2e4\uc74c \ub2e8\uacc4\ub85c \uc9c4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n\n**\uc751\ub2f5**: \ubaa8\ub4e0 \uc124\uc815 API\ub294 \ub2e4\uc74c \ub2e8\uacc4\ub97c \ubc18\ud658\ud569\ub2c8\ub2e4. (\uc644\ub8cc API \uc81c\uc678)\n")
@RestController
@RequestMapping(value={"/signup"})
public class SignupController {
    private final SignupService signupService;

    @Operation(summary="[1\ub2e8\uacc4] \uc0ac\uc6a9\uc790 \uc720\ud615 \uc124\uc815", description="\ud68c\uc6d0\uac00\uc785 \uccab \ub2e8\uacc4\ub85c, \uc608\ube44\ucc3d\uc5c5\uc790 \ub610\ub294 \uc77c\ubc18\uac70\uc8fc\ubbfc\uc744 \uc120\ud0dd\ud569\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc0ac\uc6a9\uc790 \uc720\ud615 \uc120\ud0dd", content={@Content(schema=@Schema(implementation=UserTypeRequest.class), examples={@ExampleObject(name="\uc608\ube44\ucc3d\uc5c5\uc790", value="{\"userType\": \"FOUNDER\"}"), @ExampleObject(name="\uc77c\ubc18\uac70\uc8fc\ubbfc", value="{\"userType\": \"INHABITANT\"}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658", content={@Content(schema=@Schema(implementation=SignupStep.class))}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"BAD_REQUEST\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0ac\uc6a9\uc790 \uc720\ud615\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/user-type"})
    public ResponseEntity<SignupStep> setUserType(@RequestBody @Valid UserTypeRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveUserType(session, request.userType());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[2\ub2e8\uacc4] \uc9c0\uc5ed \uc124\uc815", description="\uac70\uc8fc \uc9c0\uc5ed\uc744 \uc124\uc815\ud569\ub2c8\ub2e4. \uc9c0\uc5ed \ucf54\ub4dc\ub294 \ud589\uc815\uad6c\uc5ed \ucf54\ub4dc\ub97c \uc0ac\uc6a9\ud569\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc9c0\uc5ed \ucf54\ub4dc", content={@Content(schema=@Schema(implementation=RegionRequest.class), examples={@ExampleObject(name="\uc885\ub85c\uad6c", value="{\"regionId\": \"11110\"}"), @ExampleObject(name="\uac15\ub0a8\uad6c", value="{\"regionId\": \"11680\"}"), @ExampleObject(name="\ub9c8\ud3ec\uad6c", value="{\"regionId\": \"11560\"}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc9c0\uc5ed \ucf54\ub4dc", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"BAD_REQUEST\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc9c0\uc5ed \ucf54\ub4dc\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/region"})
    public ResponseEntity<SignupStep> setRegion(@RequestBody @Valid RegionRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveRegion(session, request.regionId());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[3\ub2e8\uacc4] \uc5f0\ub839\ub300 \uc124\uc815", description="\uc0ac\uc6a9\uc790\uc758 \uc5f0\ub839\ub300\ub97c \uc124\uc815\ud569\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc5f0\ub839\ub300 \uc120\ud0dd", content={@Content(schema=@Schema(implementation=AgeRangeRequest.class), examples={@ExampleObject(name="20\ub300", value="{\"ageRange\": \"TWENTIES\"}"), @ExampleObject(name="30\ub300", value="{\"ageRange\": \"THIRTIES\"}"), @ExampleObject(name="40\ub300", value="{\"ageRange\": \"FORTIES\"}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc5f0\ub839\ub300", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"BAD_REQUEST\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc5f0\ub839\ub300\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/age-range"})
    public ResponseEntity<SignupStep> setAgeRange(@RequestBody @Valid AgeRangeRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveAgeRange(session, request.ageRange());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[4\ub2e8\uacc4] \uc131\ubcc4 \uc124\uc815", description="\uc0ac\uc6a9\uc790\uc758 \uc131\ubcc4\uc744 \uc124\uc815\ud569\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc131\ubcc4 \uc120\ud0dd", content={@Content(schema=@Schema(implementation=GenderRequest.class), examples={@ExampleObject(name="\ub0a8\uc131", value="{\"gender\": \"MALE\"}"), @ExampleObject(name="\uc5ec\uc131", value="{\"gender\": \"FEMALE\"}"), @ExampleObject(name="\uc120\ud0dd \uc548\ud568", value="{\"gender\": \"NONE\"}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc131\ubcc4", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"BAD_REQUEST\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc131\ubcc4\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/gender"})
    public ResponseEntity<SignupStep> setGender(@RequestBody @Valid GenderRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveGender(session, request.gender());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[5\ub2e8\uacc4] \uad00\uc2ec\uc5c5\uc885 \uc124\uc815 (\uc608\ube44\ucc3d\uc5c5\uc790 \uc804\uc6a9)", description="\uc608\ube44\ucc3d\uc5c5\uc790\uac00 \uad00\uc2ec\uc788\ub294 \uc5c5\uc885\uc744 \uc124\uc815\ud569\ub2c8\ub2e4. \uc5ec\ub7ec \uac1c \uc120\ud0dd \uac00\ub2a5\ud558\uba70, \ube48 \ubc30\uc5f4\ub3c4 \ud5c8\uc6a9\ub429\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uad00\uc2ec \uc5c5\uc885 \ubaa9\ub85d", content={@Content(schema=@Schema(implementation=InterestRequest.class), examples={@ExampleObject(name="\ub2e8\uc77c \uc120\ud0dd", value="{\"interests\": [\"ACCOMMODATION_FOOD\"]}"), @ExampleObject(name="\ubcf5\uc218 \uc120\ud0dd", value="{\"interests\": [\"MANUFACTURING\", \"WHOLESALE_RETAIL\", \"ACCOMMODATION_FOOD\"]}"), @ExampleObject(name="\uc120\ud0dd \uc548\ud568", value="{\"interests\": []}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc5c5\uc885 \ucf54\ub4dc \ub610\ub294 \uc77c\ubc18\uac70\uc8fc\ubbfc \uc811\uadfc", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"STEPS_NOT_TYPE\", \"message\": \"\ud604\uc7ac \uc9c4\ud589 \ub2e8\uacc4\uc5d0\uc11c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uc694\uccad\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/interests"})
    public ResponseEntity<SignupStep> setInterests(@RequestBody @Valid InterestRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveInterests(session, request.interests());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[6\ub2e8\uacc4] \uc608\uc0b0 \uc124\uc815 (\uc608\ube44\ucc3d\uc5c5\uc790 \uc804\uc6a9)", description="\uc608\ube44\ucc3d\uc5c5\uc790\uc758 \ucc3d\uc5c5 \uc608\uc0b0\uc744 \uc124\uc815\ud569\ub2c8\ub2e4. null \uac12 \ud5c8\uc6a9 (\uac74\ub108\ub6f0\uae30 \uac00\ub2a5).", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc608\uc0b0 \uad6c\uac04 (\uc120\ud0dd\uc0ac\ud56d)", content={@Content(schema=@Schema(implementation=BudgetRequest.class), examples={@ExampleObject(name="3\ucc9c~5\ucc9c\ub9cc\uc6d0", value="{\"budget\": \"THOUSANDS_3000_5000\"}"), @ExampleObject(name="1\uc5b5 \uc774\uc0c1", value="{\"budget\": \"OVER_1B\"}"), @ExampleObject(name="\uac74\ub108\ub6f0\uae30", value="{\"budget\": null}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc608\uc0b0 \uad6c\uac04 \ub610\ub294 \uc77c\ubc18\uac70\uc8fc\ubbfc \uc811\uadfc", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"STEPS_NOT_TYPE\", \"message\": \"\ud604\uc7ac \uc9c4\ud589 \ub2e8\uacc4\uc5d0\uc11c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uc694\uccad\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/budget"})
    public ResponseEntity<SignupStep> setBudget(@RequestBody @Valid BudgetRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveBudget(session, request.budget());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[7\ub2e8\uacc4] \ucc3d\uc5c5 \uacbd\ud5d8 \uc124\uc815 (\uc608\ube44\ucc3d\uc5c5\uc790 \uc804\uc6a9)", description="\uc608\ube44\ucc3d\uc5c5\uc790\uc758 \ucc3d\uc5c5 \uacbd\ud5d8 \uc5ec\ubd80\ub97c \uc124\uc815\ud569\ub2c8\ub2e4.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\ucc3d\uc5c5 \uacbd\ud5d8 \uc5ec\ubd80", content={@Content(schema=@Schema(implementation=ExperienceRequest.class), examples={@ExampleObject(name="\uacbd\ud5d8 \uc788\uc74c", value="{\"experience\": \"YES\"}"), @ExampleObject(name="\uacbd\ud5d8 \uc5c6\uc74c", value="{\"experience\": \"NO\"}")})}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ub2e4\uc74c \ub2e8\uacc4 \ubc18\ud658"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uacbd\ud5d8 \uac12 \ub610\ub294 \uc77c\ubc18\uac70\uc8fc\ubbfc \uc811\uadfc", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"STEPS_NOT_TYPE\", \"message\": \"\ud604\uc7ac \uc9c4\ud589 \ub2e8\uacc4\uc5d0\uc11c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uc694\uccad\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/experience"})
    public ResponseEntity<SignupStep> setExperience(@RequestBody @Valid ExperienceRequest request, @Parameter(hidden=true) HttpSession session) {
        SignupStep nextStep = this.signupService.saveExperience(session, request.experience());
        return ResponseEntity.ok((Object)nextStep);
    }

    @Operation(summary="[8\ub2e8\uacc4] \ub2c9\ub124\uc784 \uc0dd\uc131", description="\uc790\ub3d9\uc73c\ub85c \uace0\uc720\ud55c \ub2c9\ub124\uc784\uc744 \uc0dd\uc131\ud569\ub2c8\ub2e4. \uc774\ubbf8 \uc0ac\uc6a9\uc911\uc778 \ub2c9\ub124\uc784\uc740 \ud53c\ud574\uc11c \uc0dd\uc131\ub429\ub2c8\ub2e4.", responses={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \uc0dd\uc131\ub41c \ub2c9\ub124\uc784 \ubc18\ud658", content={@Content(schema=@Schema(type="string", example="\ud65c\ubc1c\ud55c\ucf54\ub07c\ub9ac123"))}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/nickname"})
    public ResponseEntity<String> saveNickname(@Parameter(hidden=true) HttpSession session) {
        String nickname = this.signupService.saveNickname(session);
        return ResponseEntity.ok((Object)nickname);
    }

    @Operation(summary="[9\ub2e8\uacc4] \ud68c\uc6d0\uac00\uc785 \uc644\ub8cc", description="\ud68c\uc6d0\uac00\uc785\uc744 \uc644\ub8cc\ud558\uace0 \uc0ac\uc6a9\uc790 \uacc4\uc815\uc744 \uc0dd\uc131\ud569\ub2c8\ub2e4.\n\n**\ud1a0\ud070 \ubc1c\uae09 \ubc29\uc2dd:**\n- Response Body: accessToken \ud3ec\ud568 (\ubaa8\ubc14\uc77c \uc571 \uc9c0\uc6d0)\n- Set-Cookie \ud5e4\ub354: accessToken, refreshToken \ucfe0\ud0a4 \uc124\uc815 (\uc6f9 \ube0c\ub77c\uc6b0\uc800 \uc790\ub3d9 \uad00\ub9ac)\n\n**\ucfe0\ud0a4 \ubcf4\uc548 \uc18d\uc131:**\n- accessToken: HttpOnly=true, Secure=true, SameSite=None (XSS \ubc29\uc5b4, 30\ubd84)\n- refreshToken: HttpOnly=true, Secure=true, SameSite=None (XSS \ubc29\uc5b4, 14\uc77c)\n\n**\ud074\ub77c\uc774\uc5b8\ud2b8\ubcc4 \uc0ac\uc6a9 \ubc29\ubc95:**\n- \uc6f9 \ube0c\ub77c\uc6b0\uc800: \ucfe0\ud0a4 \uc790\ub3d9 \uad00\ub9ac, credentials: 'include' \uc124\uc815 \ud544\uc694\n- \ubaa8\ubc14\uc77c \uc571: Body\uc5d0\uc11c accessToken \ucd94\ucd9c \ud6c4 AsyncStorage/SharedPreferences \uc800\uc7a5\n", responses={@ApiResponse(responseCode="200", description="\uc131\uacf5 - Access Token \ubc0f \uc0ac\uc6a9\uc790 \uc815\ubcf4 \ubc18\ud658", content={@Content(schema=@Schema(implementation=SignupCompleteResponse.class), examples={@ExampleObject(value="{\"accessToken\": \"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...\", \"user\": {\"id\": \"550e8400-e29b-41d4-a716-446655440000\", \"username\": \"\ud64d\uae38\ub3d9\", \"nickname\": \"\uae38\ub3d9\uc774\", \"email\": \"user@example.com\"}}")})}), @ApiResponse(responseCode="400", description="\ud68c\uc6d0\uac00\uc785 \ub2e8\uacc4\uac00 \uc644\ub8cc\ub418\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"BAD_REQUEST\", \"message\": \"\ud68c\uc6d0\uac00\uc785\uc774 \uc644\ub8cc\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/complete"})
    public ResponseEntity<SignupCompleteResponse> completeSignup(@Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletResponse response) {
        SignupCompleteResponse signupCompleteResponse = this.signupService.completeSignup(session, response);
        return ResponseEntity.ok((Object)signupCompleteResponse);
    }

    @Operation(summary="\ucc3d\uc5c5 \uacbd\ud5d8 \uc815\ubcf4 \uc870\ud68c (\uc608\ube44\ucc3d\uc5c5\uc790 \uc804\uc6a9)", description="\uc774\uc804\uc5d0 \uc124\uc815\ud55c \ucc3d\uc5c5 \uacbd\ud5d8 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4. \ub4a4\ub85c\uac00\uae30 \uae30\ub2a5\uc5d0\uc11c \uc0ac\uc6a9\ub429\ub2c8\ub2e4.", responses={@ApiResponse(responseCode="200", description="\uc131\uacf5 - \ucc3d\uc5c5 \uacbd\ud5d8 \uc815\ubcf4 \ubc18\ud658", content={@Content(schema=@Schema(implementation=ExperienceRequest.class), examples={@ExampleObject(value="{\"experience\": \"YES\"}")})}), @ApiResponse(responseCode="400", description="\uc77c\ubc18\uac70\uc8fc\ubbfc \uc811\uadfc \ub610\ub294 \ub370\uc774\ud130 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"STEPS_NOT_TYPE\", \"message\": \"\ud604\uc7ac \uc9c4\ud589 \ub2e8\uacc4\uc5d0\uc11c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uc694\uccad\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc138\uc158\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\ud68c\uc6d0\uac00\uc785 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \ub85c\uadf8\uc778 \ud574\uc8fc\uc138\uc694.\"}")})})})
    @GetMapping(value={"/experience/data"})
    public ResponseEntity<ExperienceRequest> getExperience(@Parameter(hidden=true) HttpSession session) {
        return ResponseEntity.ok((Object)this.signupService.getExperience(session));
    }

    @Generated
    public SignupController(SignupService signupService) {
        this.signupService = signupService;
    }
}

