/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.domain.dto;

import com.example.soso.community.common.post.domain.dto.UserSummaryResponse;
import com.example.soso.sigungu.service.SigunguCodeService;
import com.example.soso.users.domain.dto.SignupSession;
import com.example.soso.users.domain.dto.UserResponse;
import com.example.soso.users.domain.entity.Users;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UserMapper {
    private final SigunguCodeService sigunguCodeService;

    public Users fromSignupSession(SignupSession session, String username, String email, String profileImageUrl) {
        return Users.builder().username(username).nickname(session.getNickname()).email(email).userType(session.getUserType()).gender(session.getGender()).ageRange(session.getAgeRange()).budget(session.getBudget()).startupExperience(session.getStartupExperience()).location(session.getRegionId()).interests(session.getInterests()).profileImageUrl(profileImageUrl).build();
    }

    public UserSummaryResponse toUserSummary(Users users) {
        String address = this.sigunguCodeService.convertToAddressSafe(users.getLocation());
        return new UserSummaryResponse(users.getId(), users.getNickname(), address, users.getProfileImageUrl(), users.getUserType());
    }

    public UserResponse toUserResponse(Users user) {
        String address = this.sigunguCodeService.convertToAddressSafe(user.getLocation());
        return UserResponse.builder().id(user.getId()).username(user.getUsername()).nickname(user.getNickname()).email(user.getEmail()).userType(user.getUserType()).profileImageUrl(user.getProfileImageUrl()).gender(user.getGender()).ageRange(user.getAgeRange()).budget(user.getBudget() != null ? user.getBudget().getLabel() : null).startupExperience(user.getStartupExperience() != null ? user.getStartupExperience().getLabel() : null).location(address).interests(user.getInterests() != null ? user.getInterests().stream().map(interest -> interest.getLabel()).collect(Collectors.toList()) : null).latitude(user.getLatitude()).longitude(user.getLongitude()).createdAt(user.getCreatedAt()).updatedAt(user.getUpdatedAt()).build();
    }

    @Generated
    public UserMapper(SigunguCodeService sigunguCodeService) {
        this.sigunguCodeService = sigunguCodeService;
    }
}

