/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.comment.service;

import com.example.soso.community.common.comment.domain.dto.CommentCreateRequest;
import com.example.soso.community.common.comment.domain.dto.CommentMapper;
import com.example.soso.community.common.comment.domain.dto.PostCommentResponse;
import com.example.soso.community.common.comment.domain.entity.Comment;
import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.common.comment.service.CommentService;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommentServiceImpl
implements CommentService {
    private final CommentRepository commentRepository;
    private final PostRepository postRepository;
    private final UsersRepository usersRepository;
    private final CommentMapper commentMapper;

    @Transactional
    public void create(Long postId, String userId, CommentCreateRequest request) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        Comment comment = this.commentMapper.toEntity(request, post, user);
        this.commentRepository.save((Object)comment);
    }

    @Transactional
    public void update(Long postId, Long commentId, String userId, CommentCreateRequest request) {
        Comment comment = (Comment)this.commentRepository.findByIdAndPostId(commentId, postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        this.validateCommentOwner(comment.getId(), userId);
        comment.updateContent(request.content());
    }

    public List<PostCommentResponse> getcomments(Long postId, String userId) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        List comments = this.commentRepository.findAllByPost(post);
        ArrayList<PostCommentResponse> responseList = new ArrayList<PostCommentResponse>();
        for (Comment comment : comments) {
            responseList.add(this.commentMapper.toResponse(comment));
        }
        return responseList;
    }

    @Transactional
    public void delete(Long postId, Long commentId, String userId) {
        Comment comment = (Comment)this.commentRepository.findByIdAndPostId(commentId, postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        this.validateCommentOwner(comment.getId(), userId);
        this.commentRepository.delete((Object)comment);
    }

    private void validateCommentOwner(Long commentId, String userId) {
        this.commentRepository.findByIdAndUserId(commentId, userId).orElseThrow(() -> new IllegalArgumentException("\ubcf8\uc778\uc774 \uc791\uc131\ud55c \ub313\uae00\ub9cc \uc218\uc815/\uc0ad\uc81c\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4."));
    }

    @Generated
    public CommentServiceImpl(CommentRepository commentRepository, PostRepository postRepository, UsersRepository usersRepository, CommentMapper commentMapper) {
        this.commentRepository = commentRepository;
        this.postRepository = postRepository;
        this.usersRepository = usersRepository;
        this.commentMapper = commentMapper;
    }
}

