/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.comment.service;

import com.example.soso.community.votesboard.comment.domain.entity.VotesboardComment;
import com.example.soso.community.votesboard.comment.domain.entity.VotesboardCommentLike;
import com.example.soso.community.votesboard.comment.domain.repository.VotesboardCommentLikeRepository;
import com.example.soso.community.votesboard.comment.domain.repository.VotesboardCommentRepository;
import com.example.soso.community.votesboard.comment.service.VotesboardCommentLikeService;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotesboardCommentLikeServiceImpl
implements VotesboardCommentLikeService {
    private final VotesboardCommentLikeRepository commentLikeRepository;
    private final VotesboardCommentRepository commentRepository;
    private final UsersRepository usersRepository;

    @Transactional
    public boolean toggleLike(Long commentId, String userId) {
        VotesboardComment comment = (VotesboardComment)this.commentRepository.findById((Object)commentId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.COMMENT_NOT_FOUND));
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        return this.commentLikeRepository.findByCommentAndUser(comment, user).map(existingLike -> {
            this.commentLikeRepository.delete(existingLike);
            comment.decrementLikeCount();
            return false;
        }).orElseGet(() -> {
            VotesboardCommentLike newLike = VotesboardCommentLike.create((VotesboardComment)comment, (Users)user);
            this.commentLikeRepository.save((Object)newLike);
            comment.incrementLikeCount();
            return true;
        });
    }

    public boolean isLikedByUser(Long commentId, String userId) {
        return this.commentLikeRepository.existsByCommentIdAndUserId(commentId, userId);
    }

    public long getLikeCount(Long commentId) {
        return this.commentLikeRepository.countByCommentId(commentId);
    }

    @Generated
    public VotesboardCommentLikeServiceImpl(VotesboardCommentLikeRepository commentLikeRepository, VotesboardCommentRepository commentRepository, UsersRepository usersRepository) {
        this.commentLikeRepository = commentLikeRepository;
        this.commentRepository = commentRepository;
        this.usersRepository = usersRepository;
    }
}

