/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.domain.entity;

import com.example.soso.community.votesboard.domain.entity.VoteOption;
import com.example.soso.community.votesboard.domain.entity.VoteResult;
import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.global.time.BaseTimeEntity;
import com.example.soso.users.domain.entity.Users;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.Generated;

@Entity
@Table(name="vote_result", uniqueConstraints={@UniqueConstraint(name="uk_vote_result_user_post_option", columnNames={"user_id", "votesboard_id", "vote_option_id"})}, indexes={@Index(name="idx_vote_result_user", columnList="user_id"), @Index(name="idx_vote_result_post", columnList="votesboard_id"), @Index(name="idx_vote_result_user_post", columnList="user_id, votesboard_id")})
public class VoteResult
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private Users user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="votesboard_id", nullable=false)
    private Votesboard votesboard;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vote_option_id", nullable=false)
    private VoteOption voteOption;

    public VoteResult(Users user, Votesboard votesboard, VoteOption voteOption) {
        this.user = user;
        this.votesboard = votesboard;
        this.voteOption = voteOption;
    }

    public void changeVote(VoteOption newOption) {
        this.voteOption.decreaseVoteCount();
        this.voteOption = newOption;
        newOption.increaseVoteCount();
    }

    @Generated
    public static VoteResultBuilder builder() {
        return new VoteResultBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Users getUser() {
        return this.user;
    }

    @Generated
    public Votesboard getVotesboard() {
        return this.votesboard;
    }

    @Generated
    public VoteOption getVoteOption() {
        return this.voteOption;
    }

    @Generated
    protected VoteResult() {
    }
}

