/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.config;

import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseCookie;
import org.springframework.stereotype.Component;

@Component
public class CookieUtil {
    @Value(value="${cookie.secure:true}")
    private boolean secure;
    @Value(value="${cookie.same-site:None}")
    private String sameSite;
    private static final boolean HTTP_ONLY = true;
    private static final String PATH = "/";

    public void addAccessTokenCookie(HttpServletResponse response, String accessToken, long maxAgeMs) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)"accessToken", (String)accessToken).httpOnly(true).secure(this.secure).path(PATH).maxAge(Duration.ofMillis(maxAgeMs));
        if (this.sameSite != null && !this.sameSite.isEmpty()) {
            builder.sameSite(this.sameSite);
        }
        response.addHeader("Set-Cookie", builder.build().toString());
    }

    public void addRefreshTokenCookie(HttpServletResponse response, String refreshToken, long maxAgeMs) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)"refreshToken", (String)refreshToken).httpOnly(true).secure(this.secure).path(PATH).maxAge(Duration.ofMillis(maxAgeMs));
        if (this.sameSite != null && !this.sameSite.isEmpty()) {
            builder.sameSite(this.sameSite);
        }
        response.addHeader("Set-Cookie", builder.build().toString());
    }

    public void deleteAccessTokenCookie(HttpServletResponse response) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)"accessToken", (String)"").httpOnly(true).secure(this.secure).path(PATH).maxAge(0L);
        if (this.sameSite != null && !this.sameSite.isEmpty()) {
            builder.sameSite(this.sameSite);
        }
        response.addHeader("Set-Cookie", builder.build().toString());
    }

    public void deleteRefreshTokenCookie(HttpServletResponse response) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)"refreshToken", (String)"").httpOnly(true).secure(this.secure).path(PATH).maxAge(0L);
        if (this.sameSite != null && !this.sameSite.isEmpty()) {
            builder.sameSite(this.sameSite);
        }
        response.addHeader("Set-Cookie", builder.build().toString());
    }

    @Generated
    public CookieUtil() {
    }
}

