/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.jwt;

import com.example.soso.global.jwt.JwtProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class JwtProvider {
    private final JwtProperties jwtProperties;

    private SecretKey getSigningKey() {
        return Keys.hmacShaKeyFor((byte[])this.jwtProperties.getSecretKey().getBytes(StandardCharsets.UTF_8));
    }

    public String generateAccessToken(String subject) {
        return this.generateToken(subject, this.jwtProperties.getAccessTokenValidityInMs());
    }

    public String generateRefreshToken() {
        return this.generateRefreshToken(this.jwtProperties.getRefreshTokenValidityInMs());
    }

    private String generateRefreshToken(long validityInMs) {
        Date now = new Date();
        Date expiry = new Date(now.getTime() + validityInMs);
        return ((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuedAt(now)).setExpiration(expiry)).signWith((Key)this.getSigningKey()).compact();
    }

    private String generateToken(String subject, long validityInMs) {
        Date now = new Date();
        Date expiry = new Date(now.getTime() + validityInMs);
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setSubject(subject)).setIssuedAt(now)).setExpiration(expiry)).signWith((Key)this.getSigningKey()).compact();
    }

    public boolean validateToken(String token) {
        try {
            this.getClaims(token);
            return true;
        }
        catch (JwtException | IllegalArgumentException e) {
            return false;
        }
    }

    public String getSubject(String token) {
        return ((Claims)this.getClaims(token).getPayload()).getSubject();
    }

    private Jws<Claims> getClaims(String token) {
        return Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)token);
    }

    @Generated
    public JwtProvider(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

