/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.redis;

import java.time.Duration;
import lombok.Generated;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class RefreshTokenRedisRepository {
    private final RedisTemplate<String, String> redisTemplate;
    private static final String PREFIX = "refresh-token:";

    public void save(String refreshToken, String userId, long ttlMs) {
        this.redisTemplate.opsForValue().set((Object)(PREFIX + refreshToken), (Object)userId, Duration.ofMillis(ttlMs));
    }

    public void saveByUserId(String userId, String refreshToken, long ttlMs) {
        this.redisTemplate.opsForValue().set((Object)(PREFIX + refreshToken), (Object)userId, Duration.ofMillis(ttlMs));
    }

    public String getUserIdByRefreshToken(String refreshToken) {
        return (String)this.redisTemplate.opsForValue().get((Object)(PREFIX + refreshToken));
    }

    public void delete(String refreshToken) {
        this.redisTemplate.delete((Object)(PREFIX + refreshToken));
    }

    @Generated
    public RefreshTokenRedisRepository(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

