/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.service;

import com.example.soso.global.config.CookieUtil;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.TokenErrorCode;
import com.example.soso.global.exception.util.InvalidTokenException;
import com.example.soso.global.jwt.JwtProperties;
import com.example.soso.global.jwt.JwtProvider;
import com.example.soso.global.jwt.JwtTokenDto;
import com.example.soso.global.redis.RefreshTokenRedisRepository;
import com.example.soso.users.service.AuthService;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    private final JwtProvider jwtProvider;
    private final RefreshTokenRedisRepository refreshTokenService;
    private final JwtProperties jwtProperties;
    private final CookieUtil cookieUtil;

    public JwtTokenDto refreshAccessToken(String refreshToken, HttpServletResponse response) {
        if (!this.jwtProvider.validateToken(refreshToken)) {
            throw new InvalidTokenException((BaseErrorCode)TokenErrorCode.INVALID_TOKEN);
        }
        String userId = this.refreshTokenService.getUserIdByRefreshToken(refreshToken);
        if (userId == null) {
            throw new InvalidTokenException((BaseErrorCode)TokenErrorCode.REFRESH_TOKEN_NOT_FOUND);
        }
        this.refreshTokenService.delete(refreshToken);
        String newRefreshToken = this.jwtProvider.generateRefreshToken();
        this.refreshTokenService.save(newRefreshToken, userId, this.jwtProperties.getRefreshTokenValidityInMs());
        String newAccessToken = this.jwtProvider.generateAccessToken(userId);
        this.cookieUtil.addAccessTokenCookie(response, newAccessToken, this.jwtProperties.getAccessTokenValidityInMs());
        this.cookieUtil.addRefreshTokenCookie(response, newRefreshToken, this.jwtProperties.getRefreshTokenValidityInMs());
        return new JwtTokenDto(newAccessToken);
    }

    public void logout(String refreshToken, HttpServletResponse response) {
        this.refreshTokenService.delete(refreshToken);
        this.cookieUtil.deleteAccessTokenCookie(response);
        this.cookieUtil.deleteRefreshTokenCookie(response);
    }

    @Generated
    public AuthServiceImpl(JwtProvider jwtProvider, RefreshTokenRedisRepository refreshTokenService, JwtProperties jwtProperties, CookieUtil cookieUtil) {
        this.jwtProvider = jwtProvider;
        this.refreshTokenService = refreshTokenService;
        this.jwtProperties = jwtProperties;
        this.cookieUtil = cookieUtil;
    }
}

