/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.domain.entity;

import com.example.soso.community.voteboard.domain.entity.VoteOption;
import com.example.soso.community.voteboard.domain.entity.VotePostImage;
import com.example.soso.community.voteboard.domain.entity.VoteStatus;
import com.example.soso.global.time.BaseTimeEntity;
import com.example.soso.users.domain.entity.Users;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="vote_post")
public class VotePost
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private Users user;
    @Column(nullable=false, length=100)
    private String title;
    @Lob
    @Column(nullable=false)
    private String content;
    @OneToMany(mappedBy="votePost", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence ASC")
    private List<VotePostImage> images = new ArrayList();
    @Column(name="view_count", nullable=false)
    private int viewCount = 0;
    @Column(nullable=false)
    private boolean deleted = false;
    @OneToMany(mappedBy="votePost", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence ASC")
    private List<VoteOption> voteOptions = new ArrayList();
    @Column(name="end_time", nullable=false)
    private LocalDateTime endTime;
    @Column(name="allow_revote", nullable=false)
    private boolean allowRevote = false;
    @Column(name="total_votes", nullable=false)
    private int totalVotes = 0;

    public static VotePost create(Users user, String title, String content, LocalDateTime endTime, boolean allowRevote) {
        VotePost votePost = new VotePost();
        votePost.user = user;
        votePost.title = title;
        votePost.content = content;
        votePost.endTime = endTime;
        votePost.allowRevote = allowRevote;
        votePost.totalVotes = 0;
        votePost.viewCount = 0;
        votePost.deleted = false;
        return votePost;
    }

    public void addVoteOption(VoteOption option) {
        this.voteOptions.add(option);
        option.setVotePost(this);
    }

    public void addVoteOptions(List<VoteOption> options) {
        for (VoteOption option : options) {
            this.addVoteOption(option);
        }
    }

    public void increaseTotalVotes() {
        ++this.totalVotes;
    }

    public void decreaseTotalVotes() {
        if (this.totalVotes > 0) {
            --this.totalVotes;
        }
    }

    public boolean isActive() {
        return LocalDateTime.now().isBefore(this.endTime) && !this.isDeleted();
    }

    public VoteStatus getVoteStatus() {
        if (this.isDeleted()) {
            return VoteStatus.DELETED;
        }
        return this.isActive() ? VoteStatus.IN_PROGRESS : VoteStatus.COMPLETED;
    }

    public void addImage(VotePostImage image) {
        this.images.add(image);
        image.setVotePost(this);
    }

    public void updatePost(String title, String content, List<VotePostImage> newImages) {
        if (title != null) {
            this.title = title;
        }
        if (content != null) {
            this.content = content;
        }
        if (newImages != null && !newImages.isEmpty()) {
            this.images.clear();
            this.images.addAll(newImages);
        }
    }

    public void updateVoteSettings(LocalDateTime endTime, boolean allowRevote) {
        if (this.totalVotes == 0) {
            this.endTime = endTime;
            this.allowRevote = allowRevote;
        }
    }

    public void increaseViewCount() {
        ++this.viewCount;
    }

    public void delete() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Users getUser() {
        return this.user;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<VotePostImage> getImages() {
        return this.images;
    }

    @Generated
    public int getViewCount() {
        return this.viewCount;
    }

    @Generated
    public List<VoteOption> getVoteOptions() {
        return this.voteOptions;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public boolean isAllowRevote() {
        return this.allowRevote;
    }

    @Generated
    public int getTotalVotes() {
        return this.totalVotes;
    }

    @Generated
    protected VotePost() {
    }
}

