/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.service;

import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.community.voteboard.domain.entity.VotePostLike;
import com.example.soso.community.voteboard.repository.VotePostLikeRepository;
import com.example.soso.community.voteboard.repository.VotePostRepository;
import com.example.soso.community.voteboard.service.VotePostLikeService;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotePostLikeServiceImpl
implements VotePostLikeService {
    private final VotePostLikeRepository votePostLikeRepository;
    private final VotePostRepository votePostRepository;
    private final UsersRepository usersRepository;

    @Transactional
    public boolean toggleLike(Long votePostId, String userId) {
        VotePost votePost = (VotePost)this.votePostRepository.findById((Object)votePostId).orElseThrow(() -> new IllegalArgumentException("\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ID: " + votePostId));
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new IllegalArgumentException("\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ID: " + userId));
        return this.votePostLikeRepository.findByVotePostAndUser(votePost, user).map(existingLike -> {
            this.votePostLikeRepository.delete(existingLike);
            return false;
        }).orElseGet(() -> {
            VotePostLike newLike = VotePostLike.create((VotePost)votePost, (Users)user);
            this.votePostLikeRepository.save((Object)newLike);
            return true;
        });
    }

    public boolean isLikedByUser(Long votePostId, String userId) {
        return this.votePostLikeRepository.existsByVotePostIdAndUserId(votePostId, userId);
    }

    public long getLikeCount(Long votePostId) {
        return this.votePostLikeRepository.countByVotePostId(votePostId);
    }

    @Generated
    public VotePostLikeServiceImpl(VotePostLikeRepository votePostLikeRepository, VotePostRepository votePostRepository, UsersRepository usersRepository) {
        this.votePostLikeRepository = votePostLikeRepository;
        this.votePostRepository = votePostRepository;
        this.usersRepository = usersRepository;
    }
}

