/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.post.service;

import com.example.soso.community.common.likes.repository.PostLikeRepository;
import com.example.soso.community.common.post.domain.dto.CursorDto;
import com.example.soso.community.common.post.domain.dto.PostCreateRequest;
import com.example.soso.community.common.post.domain.dto.PostCreateResponse;
import com.example.soso.community.common.post.domain.dto.PostCursorResponse;
import com.example.soso.community.common.post.domain.dto.PostMapper;
import com.example.soso.community.common.post.domain.dto.PostResponse;
import com.example.soso.community.common.post.domain.dto.PostSortType;
import com.example.soso.community.common.post.domain.dto.PostSummaryResponse;
import com.example.soso.community.common.post.domain.dto.PostUpdateRequest;
import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.domain.entity.PostImage;
import com.example.soso.community.common.post.repository.PostImageRepository;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.community.common.post.service.PostService;
import com.example.soso.community.common.post.service.PostServiceImpl;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.s3.S3Service;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PostServiceImpl
implements PostService {
    private final PostRepository postRepository;
    private final PostImageRepository postImageRepository;
    private final S3Service s3Service;
    private final UsersRepository usersRepository;
    private final PostLikeRepository postLikeRepository;
    private final PostMapper postMapper;

    @Transactional
    public PostCreateResponse createPost(PostCreateRequest request, String userId) {
        Users users = this.getUserById(userId);
        Post post = this.postMapper.toEntity(request, users);
        this.postRepository.save((Object)post);
        List postImages = this.createPostImages(request.images(), post);
        postImages.forEach(image -> {
            this.postImageRepository.save(image);
            post.addImage(image);
        });
        return new PostCreateResponse(post.getId());
    }

    @Transactional(readOnly=true)
    public PostResponse getPost(Long postId, String userId) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        boolean isLiked = this.postLikeRepository.existsByPost_IdAndUser_Id(postId, userId);
        return this.postMapper.toResponse(post, isLiked);
    }

    @Transactional(readOnly=true)
    public PostCursorResponse getPostsByCursor(Category category, PostSortType sort, int size, String cursor, Long idAfter, String userId) {
        List posts = this.postRepository.findAllByCursorPaging(category, sort, size + 1, cursor, idAfter, userId);
        boolean hasNext = posts.size() > size;
        String nextCursor = null;
        Long nextIdAfter = null;
        if (hasNext) {
            PostSummaryResponse lastPost = (PostSummaryResponse)posts.get(size);
            nextCursor = switch (1.$SwitchMap$com$example$soso$community$common$post$domain$dto$PostSortType[sort.ordinal()]) {
                default -> throw new MatchException(null, null);
                case 1 -> lastPost.createdAt().toString();
                case 2 -> String.valueOf(lastPost.likeCount());
                case 3 -> String.valueOf(lastPost.commentCount());
                case 4 -> String.valueOf(lastPost.viewCount());
            };
            nextIdAfter = lastPost.postId();
            posts.remove(size);
        }
        CursorDto cursorDto = new CursorDto(Boolean.valueOf(hasNext), nextCursor, nextIdAfter);
        return new PostCursorResponse(posts, cursorDto);
    }

    @Transactional
    public PostCreateResponse updatePost(Long postId, PostUpdateRequest request, String userId) {
        Post post = (Post)this.postRepository.findByIdAndUserId(postId, userId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.FORBIDDEN));
        post.getImages().forEach(image -> this.s3Service.deleteImage(image.getImageUrl()));
        post.getImages().clear();
        List postImages = this.createPostImages(request.images(), post);
        postImages.forEach(arg_0 -> ((Post)post).addImage(arg_0));
        post.update(request.title(), request.content(), request.category(), postImages);
        return new PostCreateResponse(post.getId());
    }

    @Transactional
    public void deletePost(Long postId, String userId) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        this.postRepository.findByIdAndUserId(postId, userId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.FORBIDDEN));
        post.getImages().forEach(image -> this.s3Service.deleteImage(image.getImageUrl()));
        post.getImages().clear();
        post.delete();
    }

    @Transactional
    public void hardDeletePost(Long postId, String userId) {
        Post post = (Post)this.postRepository.findById((Object)postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
        this.postRepository.findByIdAndUserId(postId, userId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.FORBIDDEN));
        post.getImages().forEach(image -> this.s3Service.deleteImage(image.getImageUrl()));
        this.postRepository.delete((Object)post);
    }

    private List<PostImage> createPostImages(List<MultipartFile> images, Post post) {
        ArrayList<PostImage> postImages = new ArrayList<PostImage>();
        if (images == null || images.isEmpty()) {
            return postImages;
        }
        for (int i = 0; i < images.size(); ++i) {
            MultipartFile file = images.get(i);
            String imageUrl = this.s3Service.uploadImage(file, "posts");
            PostImage postImage = PostImage.builder().imageUrl(imageUrl).sequence(i).post(post).build();
            postImages.add(postImage);
        }
        return postImages;
    }

    private Users getUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    @Generated
    public PostServiceImpl(PostRepository postRepository, PostImageRepository postImageRepository, S3Service s3Service, UsersRepository usersRepository, PostLikeRepository postLikeRepository, PostMapper postMapper) {
        this.postRepository = postRepository;
        this.postImageRepository = postImageRepository;
        this.s3Service = s3Service;
        this.usersRepository = usersRepository;
        this.postLikeRepository = postLikeRepository;
        this.postMapper = postMapper;
    }
}

