/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.comment.service;

import com.example.soso.community.voteboard.comment.domain.entity.VoteboardComment;
import com.example.soso.community.voteboard.comment.domain.entity.VoteboardCommentLike;
import com.example.soso.community.voteboard.comment.domain.repository.VoteboardCommentLikeRepository;
import com.example.soso.community.voteboard.comment.domain.repository.VoteboardCommentRepository;
import com.example.soso.community.voteboard.comment.service.VoteboardCommentLikeService;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VoteboardCommentLikeServiceImpl
implements VoteboardCommentLikeService {
    private final VoteboardCommentLikeRepository commentLikeRepository;
    private final VoteboardCommentRepository commentRepository;
    private final UsersRepository usersRepository;

    @Transactional
    public boolean toggleLike(Long commentId, String userId) {
        VoteboardComment comment = (VoteboardComment)this.commentRepository.findById((Object)commentId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.COMMENT_NOT_FOUND));
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        return this.commentLikeRepository.findByCommentAndUser(comment, user).map(existingLike -> {
            this.commentLikeRepository.delete(existingLike);
            comment.decrementLikeCount();
            return false;
        }).orElseGet(() -> {
            VoteboardCommentLike newLike = VoteboardCommentLike.create((VoteboardComment)comment, (Users)user);
            this.commentLikeRepository.save((Object)newLike);
            comment.incrementLikeCount();
            return true;
        });
    }

    public boolean isLikedByUser(Long commentId, String userId) {
        return this.commentLikeRepository.existsByCommentIdAndUserId(commentId, userId);
    }

    public long getLikeCount(Long commentId) {
        return this.commentLikeRepository.countByCommentId(commentId);
    }

    @Generated
    public VoteboardCommentLikeServiceImpl(VoteboardCommentLikeRepository commentLikeRepository, VoteboardCommentRepository commentRepository, UsersRepository usersRepository) {
        this.commentLikeRepository = commentLikeRepository;
        this.commentRepository = commentRepository;
        this.usersRepository = usersRepository;
    }
}

