/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.config;

import java.net.URI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@Configuration
public class S3Config {
    @Value(value="${spring.cloud.aws.region:ap-northeast-2}")
    private String region;
    @Value(value="${spring.cloud.aws.credentials.access-key:}")
    private String accessKey;
    @Value(value="${spring.cloud.aws.credentials.secret-key:}")
    private String secretKey;
    @Value(value="${spring.cloud.aws.s3.endpoint:}")
    private String endpoint;
    @Value(value="${spring.cloud.aws.s3.path-style-access:false}")
    private boolean pathStyleAccess;

    @Bean
    public S3Client s3Client() {
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().region(Region.of((String)this.region));
        if (this.hasText(this.accessKey) && this.hasText(this.secretKey)) {
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey);
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
        } else {
            builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        }
        if (this.hasText(this.endpoint)) {
            builder.endpointOverride(URI.create(this.endpoint));
        }
        if (this.pathStyleAccess) {
            builder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
        return (S3Client)builder.build();
    }

    private boolean hasText(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

