/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.image.service;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Service
public class ImageUploadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageUploadService.class);
    private final S3Client s3Client;
    @Value(value="${spring.cloud.aws.s3.bucket}")
    private String bucketName;
    @Value(value="${spring.cloud.aws.s3.base-url}")
    private String baseUrl;
    private static final Set<String> ALLOWED_CONTENT_TYPES = Set.of("image/jpeg", "image/jpg", "image/png", "image/gif", "image/webp");
    private static final long MAX_FILE_SIZE = 0x500000L;
    private static final int MAX_IMAGE_COUNT = 4;
    private final Executor uploadExecutor = Executors.newFixedThreadPool(4);

    public List<String> uploadImages(List<MultipartFile> images, String directory) {
        if (images == null || images.isEmpty()) {
            return Collections.emptyList();
        }
        if (images.size() > 4) {
            throw new IllegalArgumentException("\uc774\ubbf8\uc9c0\ub294 \ucd5c\ub300 4\uc7a5\uae4c\uc9c0 \uc5c5\ub85c\ub4dc \uac00\ub2a5\ud569\ub2c8\ub2e4.");
        }
        log.info("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc2dc\uc791: count={}, directory={}", (Object)images.size(), (Object)directory);
        this.validateImages(images);
        ArrayList<CompletableFuture<String>> uploadFutures = new ArrayList<CompletableFuture<String>>();
        for (MultipartFile image : images) {
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> this.uploadSingleImage(image, directory), this.uploadExecutor);
            uploadFutures.add(future);
        }
        List<String> uploadedUrls = uploadFutures.stream().map(CompletableFuture::join).toList();
        log.info("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc644\ub8cc: count={}, urls={}", (Object)uploadedUrls.size(), uploadedUrls);
        return uploadedUrls;
    }

    public String uploadSingleImage(MultipartFile image, String directory) {
        this.validateSingleImage(image);
        String fileName = this.generateUniqueFileName(image.getOriginalFilename(), directory);
        String key = directory + "/" + fileName;
        try {
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(key).contentType(image.getContentType()).contentLength(Long.valueOf(image.getSize())).build();
            this.s3Client.putObject(putObjectRequest, RequestBody.fromInputStream((InputStream)image.getInputStream(), (long)image.getSize()));
            String imageUrl = this.buildObjectUrl(key);
            log.debug("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc131\uacf5: key={}, url={}", (Object)key, (Object)imageUrl);
            return imageUrl;
        }
        catch (IOException e) {
            log.error("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc2e4\ud328: key={}, error={}", (Object)key, (Object)e.getMessage());
            throw new RuntimeException("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: " + e.getMessage(), e);
        }
    }

    public void deleteImage(String imageUrl) {
        if (!(this.hasText(this.baseUrl) && this.hasText(imageUrl) && imageUrl.startsWith(this.baseUrl + "/"))) {
            log.warn("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc774\ubbf8\uc9c0 URL\ub85c \uc0ad\uc81c \uc694\uccad: {}", (Object)imageUrl);
            return;
        }
        String key = imageUrl.substring((this.baseUrl + "/").length());
        try {
            DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(key).build();
            this.s3Client.deleteObject(deleteObjectRequest);
            log.info("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc644\ub8cc: key={}", (Object)key);
        }
        catch (Exception e) {
            log.error("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc2e4\ud328: key={}, error={}", (Object)key, (Object)e.getMessage());
            throw new RuntimeException("\uc774\ubbf8\uc9c0 \uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: " + e.getMessage(), e);
        }
    }

    public void deleteImages(List<String> imageUrls) {
        if (imageUrls == null || imageUrls.isEmpty()) {
            return;
        }
        log.info("\uc774\ubbf8\uc9c0 \uc77c\uad04 \uc0ad\uc81c \uc2dc\uc791: count={}", (Object)imageUrls.size());
        List<CompletableFuture> deleteFutures = imageUrls.stream().map(url -> CompletableFuture.runAsync(() -> this.deleteImage(url), this.uploadExecutor)).toList();
        CompletableFuture.allOf(deleteFutures.toArray(new CompletableFuture[0])).join();
        log.info("\uc774\ubbf8\uc9c0 \uc77c\uad04 \uc0ad\uc81c \uc644\ub8cc: count={}", (Object)imageUrls.size());
    }

    private void validateImages(List<MultipartFile> images) {
        for (MultipartFile image : images) {
            this.validateSingleImage(image);
        }
    }

    @PostConstruct
    private void normalizeBaseUrl() {
        this.baseUrl = this.trimTrailingSlashes(this.baseUrl);
    }

    private void validateSingleImage(MultipartFile image) {
        if (image == null || image.isEmpty()) {
            throw new IllegalArgumentException("\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
        }
        if (image.getSize() > 0x500000L) {
            throw new IllegalArgumentException(String.format("\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. (\ucd5c\ub300 %dMB, \ud604\uc7ac %.2fMB)", 5L, (double)image.getSize() / 1048576.0));
        }
        String contentType = image.getContentType();
        if (contentType == null || !ALLOWED_CONTENT_TYPES.contains(contentType.toLowerCase())) {
            throw new IllegalArgumentException("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd\uc785\ub2c8\ub2e4. \uc9c0\uc6d0 \ud615\uc2dd: " + String.join((CharSequence)", ", ALLOWED_CONTENT_TYPES));
        }
        String originalFilename = image.getOriginalFilename();
        if (originalFilename == null || originalFilename.trim().isEmpty()) {
            throw new IllegalArgumentException("\ud30c\uc77c\uba85\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String generateUniqueFileName(String originalFilename, String directory) {
        String extension = this.getFileExtension(originalFilename);
        String uniqueId = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis());
        return String.format("%s_%s%s", uniqueId, timestamp, extension);
    }

    private String getFileExtension(String filename) {
        if (filename == null || filename.lastIndexOf(46) == -1) {
            return "";
        }
        return filename.substring(filename.lastIndexOf(46)).toLowerCase();
    }

    public Set<String> getSupportedContentTypes() {
        return Collections.unmodifiableSet(ALLOWED_CONTENT_TYPES);
    }

    public long getMaxFileSize() {
        return 0x500000L;
    }

    public int getMaxImageCount() {
        return 4;
    }

    private String buildObjectUrl(String key) {
        return this.baseUrl + "/" + key;
    }

    private String trimTrailingSlashes(String value) {
        int end;
        if (value == null) {
            return null;
        }
        for (end = value.length(); end > 0 && value.charAt(end - 1) == '/'; --end) {
        }
        return value.substring(0, end);
    }

    private boolean hasText(String value) {
        return value != null && !value.trim().isEmpty();
    }

    @Generated
    public ImageUploadService(S3Client s3Client) {
        this.s3Client = s3Client;
    }
}

