/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.comment.service;

import com.example.soso.community.common.comment.domain.dto.CommentLikeResponse;
import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.redis.CommentLikeRedisRepository;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PostCommentLikeService {
    private final CommentLikeRedisRepository redisRepository;
    private final CommentRepository commentRepository;
    private final PostRepository postRepository;

    public CommentLikeResponse likeComment(Long postId, Long commentId, String userId) {
        this.validateCommentBelongsToPost(commentId, postId);
        if (!this.redisRepository.isLiked(commentId, userId)) {
            this.redisRepository.addLike(commentId, userId);
        }
        long count = this.redisRepository.getLikeCount(commentId);
        return new CommentLikeResponse(true, count);
    }

    public CommentLikeResponse unlikeComment(Long postId, Long commentId, String userId) {
        this.validateCommentBelongsToPost(commentId, postId);
        if (this.redisRepository.isLiked(commentId, userId)) {
            this.redisRepository.removeLike(commentId, userId);
        }
        long count = this.redisRepository.getLikeCount(commentId);
        return new CommentLikeResponse(false, count);
    }

    public boolean isLiked(Long postId, Long commentId, String userId) {
        this.validateCommentBelongsToPost(commentId, postId);
        return this.redisRepository.isLiked(commentId, userId);
    }

    public List<Long> getLikedCommentIds(Long postId, String userId) {
        if (!this.postRepository.existsById((Object)postId)) {
            throw new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND);
        }
        List commentIds = this.commentRepository.findIdsByPostId(postId);
        return commentIds.stream().filter(commentId -> this.redisRepository.isLiked(commentId, userId)).toList();
    }

    private void validateCommentBelongsToPost(Long commentId, Long postId) {
        this.commentRepository.findByIdAndPostId(commentId, postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
    }

    @Generated
    public PostCommentLikeService(CommentLikeRedisRepository redisRepository, CommentRepository commentRepository, PostRepository postRepository) {
        this.redisRepository = redisRepository;
        this.commentRepository = commentRepository;
        this.postRepository = postRepository;
    }
}

