/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.freeboard.comment.service;

import com.example.soso.community.common.comment.domain.entity.Comment;
import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.common.likes.domain.CommentLike;
import com.example.soso.community.common.likes.repository.CommentLikeRepository;
import com.example.soso.community.freeboard.comment.service.FreeboardCommentLikeService;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.CommentErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.CommentException;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.redis.CommentLikeRedisRepository;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FreeboardCommentLikeServiceImpl
implements FreeboardCommentLikeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FreeboardCommentLikeServiceImpl.class);
    private final CommentLikeRepository commentLikeRepository;
    private final CommentRepository commentRepository;
    private final UsersRepository usersRepository;
    private final CommentLikeRedisRepository commentLikeRedisRepository;

    @Transactional
    public boolean toggleCommentLike(Long freeboardId, Long commentId, String userId) {
        log.info("\ub313\uae00 \uc88b\uc544\uc694 \ud1a0\uae00: freeboardId={}, commentId={}, userId={}", new Object[]{freeboardId, commentId, userId});
        Comment comment = (Comment)this.commentRepository.findByIdAndPostId(commentId, freeboardId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.COMMENT_NOT_FOUND));
        if (comment.isDeleted()) {
            throw new CommentException(CommentErrorCode.DELETED_COMMENT_CANNOT_BE_MODIFIED);
        }
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        boolean alreadyLiked = this.commentLikeRedisRepository.isLiked(commentId, userId);
        if (alreadyLiked) {
            this.commentLikeRedisRepository.removeLike(commentId, userId);
            this.commentLikeRepository.deleteByComment_IdAndUser_Id(commentId, userId);
            log.info("\ub313\uae00 \uc88b\uc544\uc694 \ucde8\uc18c \uc644\ub8cc: commentId={}, userId={}", (Object)commentId, (Object)userId);
            return false;
        }
        this.commentLikeRedisRepository.addLike(commentId, userId);
        CommentLike commentLike = CommentLike.builder().comment(comment).user(user).build();
        this.commentLikeRepository.save((Object)commentLike);
        log.info("\ub313\uae00 \uc88b\uc544\uc694 \ucd94\uac00 \uc644\ub8cc: commentId={}, userId={}", (Object)commentId, (Object)userId);
        return true;
    }

    @Transactional(readOnly=true)
    public boolean isCommentLikedByUser(Long freeboardId, Long commentId, String userId) {
        log.debug("\ub313\uae00 \uc88b\uc544\uc694 \uc0c1\ud0dc \ud655\uc778: freeboardId={}, commentId={}, userId={}", new Object[]{freeboardId, commentId, userId});
        this.commentRepository.findByIdAndPostId(commentId, freeboardId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.COMMENT_NOT_FOUND));
        this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        boolean isLiked = this.commentLikeRedisRepository.isLiked(commentId, userId);
        log.debug("\ub313\uae00 \uc88b\uc544\uc694 \uc0c1\ud0dc: commentId={}, userId={}, isLiked={}", new Object[]{commentId, userId, isLiked});
        return isLiked;
    }

    @Generated
    public FreeboardCommentLikeServiceImpl(CommentLikeRepository commentLikeRepository, CommentRepository commentRepository, UsersRepository usersRepository, CommentLikeRedisRepository commentLikeRedisRepository) {
        this.commentLikeRepository = commentLikeRepository;
        this.commentRepository = commentRepository;
        this.usersRepository = usersRepository;
        this.commentLikeRedisRepository = commentLikeRedisRepository;
    }
}

