/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.s3;

import com.example.soso.global.s3.ImageResizeUtil;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(prefix="storage", name={"provider"}, havingValue="gcs")
public class GcsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GcsService.class);
    private final Storage storage;
    @Value(value="${spring.cloud.gcp.storage.bucket}")
    private String bucket;
    @Value(value="${spring.cloud.gcp.storage.base-url}")
    private String baseUrl;

    public String uploadImage(MultipartFile file, String dir) {
        try {
            byte[] resizedImage = ImageResizeUtil.resizeToJpg((MultipartFile)file);
            String fileName = dir + "/" + String.valueOf(UUID.randomUUID()) + ".jpg";
            BlobId blobId = BlobId.of((String)this.bucket, (String)fileName);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType("image/jpeg").build();
            this.storage.create(blobInfo, resizedImage, new Storage.BlobTargetOption[0]);
            return this.baseUrl + "/" + fileName;
        }
        catch (IOException e) {
            log.error("GCS \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc2e4\ud328", (Throwable)e);
            throw new RuntimeException("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }

    public void deleteImage(String imageUrl) {
        String key = this.extractKeyFromUrl(imageUrl);
        boolean deleted = this.storage.delete(this.bucket, key, new Storage.BlobSourceOption[0]);
        if (!deleted) {
            log.warn("\uc0ad\uc81c \uc2e4\ud328: \uac1d\uccb4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c - {}", (Object)key);
        }
    }

    public boolean isImageExists(String imageUrl) {
        String key = this.extractKeyFromUrl(imageUrl);
        return this.storage.get(this.bucket, key, new Storage.BlobGetOption[0]) != null;
    }

    private String extractKeyFromUrl(String url) {
        return url.replace(this.baseUrl + "/", "");
    }

    @Generated
    public GcsService(Storage storage) {
        this.storage = storage;
    }
}

