/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.service;

import com.example.soso.community.common.likes.domain.PostLike;
import com.example.soso.community.common.likes.repository.PostLikeRepository;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractLikeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLikeService.class);
    protected final PostLikeRepository postLikeRepository;
    protected final PostRepository postRepository;
    protected final UsersRepository usersRepository;

    @Transactional
    public boolean toggleLike(Long postId, String userId) {
        log.info("\uc88b\uc544\uc694 \ud1a0\uae00: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = this.findPostById(postId);
        Users user = this.findUserById(userId);
        boolean alreadyLiked = this.postLikeRepository.existsByPost_IdAndUser_Id(postId, userId);
        if (alreadyLiked) {
            this.postLikeRepository.deleteByPostIdAndUserId(postId, userId);
            log.info("\uc88b\uc544\uc694 \ucde8\uc18c \uc644\ub8cc: postId={}, userId={}", (Object)postId, (Object)userId);
            this.updatePostLikeCount(post);
            return false;
        }
        PostLike postLike = PostLike.builder().post(post).user(user).build();
        this.postLikeRepository.save((Object)postLike);
        log.info("\uc88b\uc544\uc694 \ucd94\uac00 \uc644\ub8cc: postId={}, userId={}", (Object)postId, (Object)userId);
        this.updatePostLikeCount(post);
        return true;
    }

    @Transactional(readOnly=true)
    public Set<Long> getLikedPostIds(List<Long> postIds, String userId) {
        return this.postLikeRepository.findPostIdsByPostIdsAndUserId(postIds, userId);
    }

    @Transactional(readOnly=true)
    public boolean isLikedByUser(Long postId, String userId) {
        return this.postLikeRepository.existsByPost_IdAndUser_Id(postId, userId);
    }

    protected Post findPostById(Long postId) {
        return (Post)this.postRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.NOT_FOUND));
    }

    protected Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    protected void updatePostLikeCount(Post post) {
        int likeCount = this.postLikeRepository.countByPost_Id(post.getId());
        post.updateLikeCount(likeCount);
    }

    @Generated
    public AbstractLikeService(PostLikeRepository postLikeRepository, PostRepository postRepository, UsersRepository usersRepository) {
        this.postLikeRepository = postLikeRepository;
        this.postRepository = postRepository;
        this.usersRepository = usersRepository;
    }
}

