/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.config;

import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import org.springframework.http.ResponseCookie;

public class CookieUtil {
    private static final String SAME_SITE = "None";
    private static final boolean SECURE = true;
    private static final boolean HTTP_ONLY = true;
    private static final String PATH = "/";

    public static void addAccessTokenCookie(HttpServletResponse response, String accessToken, long maxAgeMs) {
        ResponseCookie cookie = ResponseCookie.from((String)"accessToken", (String)accessToken).httpOnly(false).secure(true).path(PATH).maxAge(Duration.ofMillis(maxAgeMs)).sameSite(SAME_SITE).build();
        response.addHeader("Set-Cookie", cookie.toString());
    }

    public static void addRefreshTokenCookie(HttpServletResponse response, String refreshToken, long maxAgeMs) {
        ResponseCookie cookie = ResponseCookie.from((String)"refreshToken", (String)refreshToken).httpOnly(true).secure(true).path(PATH).maxAge(Duration.ofMillis(maxAgeMs)).sameSite(SAME_SITE).build();
        response.addHeader("Set-Cookie", cookie.toString());
    }

    public static void deleteAccessTokenCookie(HttpServletResponse response) {
        ResponseCookie cookie = ResponseCookie.from((String)"accessToken", (String)"").httpOnly(false).secure(true).path(PATH).maxAge(0L).sameSite(SAME_SITE).build();
        response.addHeader("Set-Cookie", cookie.toString());
    }

    public static void deleteRefreshTokenCookie(HttpServletResponse response) {
        ResponseCookie cookie = ResponseCookie.from((String)"refreshToken", (String)"").httpOnly(true).secure(true).path(PATH).maxAge(0L).sameSite(SAME_SITE).build();
        response.addHeader("Set-Cookie", cookie.toString());
    }
}

