/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.freeboard.like.controller;

import com.example.soso.community.freeboard.like.service.FreeboardLikeService;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.security.domain.CustomUserDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Freeboard Like", description="\uc790\uc720\uac8c\uc2dc\ud310 \uc88b\uc544\uc694 API")
@RestController
@RequestMapping(value={"/community/freeboard/{freeboardId}/like"})
public class FreeboardLikeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FreeboardLikeController.class);
    private final FreeboardLikeService freeboardLikeService;

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc88b\uc544\uc694 \ud1a0\uae00", description="\uac8c\uc2dc\uae00\uc5d0 \uc88b\uc544\uc694\ub97c \ucd94\uac00\ud558\uac70\ub098 \ucde8\uc18c\ud569\ub2c8\ub2e4.\n\n**\ub3d9\uc791 \ubc29\uc2dd:**\n- \uc774\ubbf8 \uc88b\uc544\uc694\ud55c \uac8c\uc2dc\uae00\uc774\uba74 \uc88b\uc544\uc694\ub97c \ucde8\uc18c\ud558\uace0 false \ubc18\ud658\n- \uc88b\uc544\uc694\ud558\uc9c0 \uc54a\uc740 \uac8c\uc2dc\uae00\uc774\uba74 \uc88b\uc544\uc694\ub97c \ucd94\uac00\ud558\uace0 true \ubc18\ud658\n\n**\uc778\uc99d:** \ub85c\uadf8\uc778 \ud544\uc218\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc88b\uc544\uc694 \ud1a0\uae00 \uc131\uacf5", content={@Content(examples={@ExampleObject(name="\uc88b\uc544\uc694 \ucd94\uac00", value="true"), @ExampleObject(name="\uc88b\uc544\uc694 \ucde8\uc18c", value="false")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @PostMapping
    public ResponseEntity<?> toggleLike(@Parameter(description="\uc790\uc720\uac8c\uc2dc\ud310 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("toggleLike \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: freeboardId={}", (Object)freeboardId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uac8c\uc2dc\uae00 \uc88b\uc544\uc694 \ud1a0\uae00: freeboardId={}, userId={}", (Object)freeboardId, (Object)userDetails.getUsername());
        boolean isLiked = this.freeboardLikeService.toggleLike(freeboardId, userDetails.getUsername());
        return ResponseEntity.ok((Object)isLiked);
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc88b\uc544\uc694 \uc0c1\ud0dc \ud655\uc778", description="\uc0ac\uc6a9\uc790\uac00 \ud2b9\uc815 \uac8c\uc2dc\uae00\uc5d0 \uc88b\uc544\uc694\ub97c \ud588\ub294\uc9c0 \ud655\uc778\ud569\ub2c8\ub2e4.\n\n**\uc778\uc99d:** \ub85c\uadf8\uc778 \ud544\uc218\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc88b\uc544\uc694 \uc0c1\ud0dc \uc870\ud68c \uc131\uacf5", content={@Content(examples={@ExampleObject(name="\uc88b\uc544\uc694 \ud55c \uc0c1\ud0dc", value="true"), @ExampleObject(name="\uc88b\uc544\uc694 \uc548 \ud55c \uc0c1\ud0dc", value="false")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @GetMapping
    public ResponseEntity<?> getLikeStatus(@Parameter(description="\uc790\uc720\uac8c\uc2dc\ud310 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("getLikeStatus \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: freeboardId={}", (Object)freeboardId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.debug("\uc790\uc720\uac8c\uc2dc\ud310 \uac8c\uc2dc\uae00 \uc88b\uc544\uc694 \uc0c1\ud0dc \uc870\ud68c: freeboardId={}, userId={}", (Object)freeboardId, (Object)userDetails.getUsername());
        boolean isLiked = this.freeboardLikeService.isLikedByUser(freeboardId, userDetails.getUsername());
        return ResponseEntity.ok((Object)isLiked);
    }

    @Generated
    public FreeboardLikeController(FreeboardLikeService freeboardLikeService) {
        this.freeboardLikeService = freeboardLikeService;
    }
}

