/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.comment.controller;

import com.example.soso.community.voteboard.comment.domain.dto.VoteboardCommentCreateRequest;
import com.example.soso.community.voteboard.comment.domain.dto.VoteboardCommentCreateResponse;
import com.example.soso.community.voteboard.comment.domain.dto.VoteboardCommentCursorResponse;
import com.example.soso.community.voteboard.comment.domain.dto.VoteboardCommentSortType;
import com.example.soso.community.voteboard.comment.domain.dto.VoteboardCommentUpdateRequest;
import com.example.soso.community.voteboard.comment.service.VoteboardCommentService;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.security.domain.CustomUserDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Voteboard Comment", description="\ud22c\ud45c \uac8c\uc2dc\ud310 \ub313\uae00 API")
@RestController
@RequestMapping(value={"/community/votesboard/{votePostId}/comments"})
public class VoteboardCommentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoteboardCommentController.class);
    private final VoteboardCommentService commentService;

    @Operation(summary="\ub313\uae00 \uc791\uc131", description="\ud22c\ud45c \uac8c\uc2dc\ud310 \uac8c\uc2dc\uae00\uc5d0 \ub313\uae00\uc744 \uc791\uc131\ud569\ub2c8\ub2e4.\n\n**\ud2b9\uc9d5:**\n- \uc77c\ubc18 \ub313\uae00\uacfc \ub300\ub313\uae00 \uc9c0\uc6d0\n- \ub300\ub313\uae00 \uc791\uc131 \uc2dc parentCommentId \ud544\uc218\n- \uc775\uba85 \ub313\uae00 \ubd88\uac00 (\ub85c\uadf8\uc778 \ud544\uc218)\n", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\ub313\uae00 \uc791\uc131 \uc694\uccad", content={@Content(schema=@Schema(implementation=VoteboardCommentCreateRequest.class))}))
    @ApiResponses(value={@ApiResponse(responseCode="201", description="\ub313\uae00 \uc791\uc131 \uc131\uacf5", content={@Content(schema=@Schema(implementation=VoteboardCommentCreateResponse.class), examples={@ExampleObject(value="{\"commentId\": 456}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ube48 \ub0b4\uc6a9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[content] \ub313\uae00 \ub0b4\uc6a9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ub313\uae00 \uae38\uc774 \ucd08\uacfc", value="{\"code\": \"COMMENT_CONTENT_TOO_LONG\", \"message\": \"\ub313\uae00\uc774 \ub108\ubb34 \uae41\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ub300\ub313\uae00 \uc81c\ud55c", value="{\"code\": \"REPLY_DEPTH_EXCEEDED\", \"message\": \"\ub300\ub313\uae00\uc758 \ub300\ub313\uae00\uc740 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @PostMapping
    public ResponseEntity<?> createComment(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long votePostId, @RequestBody @Valid VoteboardCommentCreateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc791\uc131 \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: votePostId={}", (Object)votePostId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc791\uc131 \uc694\uccad: votePostId={}, userId={}, parentCommentId={}", new Object[]{votePostId, userDetails.getUser().getId(), request.getParentCommentId()});
        String userId = userDetails.getUser().getId();
        VoteboardCommentCreateResponse response = this.commentService.createComment(votePostId, request, userId);
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc791\uc131 \uc644\ub8cc: commentId={}", (Object)response.getCommentId());
        return ResponseEntity.status((int)201).body((Object)response);
    }

    @Operation(summary="\ub313\uae00 \ubaa9\ub85d \uc870\ud68c (\ucee4\uc11c \uae30\ubc18)", description="\uac8c\uc2dc\uae00\uc758 \ub313\uae00 \ubaa9\ub85d\uc744 \ucee4\uc11c \uae30\ubc18\uc73c\ub85c \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\uc815\ub82c \uc635\uc158:**\n- LATEST: \ucd5c\uc2e0\uc21c (\uae30\ubcf8\uac12)\n- OLDEST: \uc624\ub798\ub41c\uc21c\n\n**\ud2b9\uc9d5:**\n- \uacc4\uce35 \uad6c\uc870 \uc9c0\uc6d0 (\ubd80\ubaa8 \ub313\uae00 \u2192 \ub300\ub313\uae00)\n- \uc0ad\uc81c\ub41c \ub313\uae00\uc740 \"\uc0ad\uc81c\ub41c \ub313\uae00\uc785\ub2c8\ub2e4\" \ud45c\uc2dc\n- \ucd1d \ub313\uae00 \uc218 \uc81c\uacf5 (total)\n- \uc778\uc99d/\ube44\uc778\uc99d \uc0ac\uc6a9\uc790 \ubaa8\ub450 \uc870\ud68c \uac00\ub2a5\n\n**\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: true\n- isLiked: boolean (\uc88b\uc544\uc694 \uc0c1\ud0dc)\n- canEdit: boolean (\uc218\uc815 \uad8c\ud55c)\n- canDelete: boolean (\uc0ad\uc81c \uad8c\ud55c)\n\n**\ube44\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: false\n- isLiked: null\n- canEdit: null\n- canDelete: null\n", parameters={@Parameter(name="sort", description="\uc815\ub82c \uc21c\uc11c", example="LATEST"), @Parameter(name="cursor", description="\ucee4\uc11c \uac12 (\ub2e4\uc74c \ud398\uc774\uc9c0\uc6a9)", example="2024-12-25T10:00:00"), @Parameter(name="size", description="\ud398\uc774\uc9c0 \ud06c\uae30 (1-50)", example="20")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc870\ud68c \uc131\uacf5", content={@Content(schema=@Schema(implementation=VoteboardCommentCursorResponse.class))}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \ud30c\ub77c\ubbf8\ud130", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc798\ubabb\ub41c \uc815\ub82c \uac12", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'INVALID_SORT'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [LATEST, OLDEST]\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @GetMapping
    public ResponseEntity<VoteboardCommentCursorResponse> getCommentsByCursor(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long votePostId, @RequestParam(defaultValue="LATEST") VoteboardCommentSortType sort, @RequestParam(required=false) String cursor, @RequestParam(defaultValue="20") int size) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userId = null;
        if (authentication != null && authentication.isAuthenticated() && !"anonymousUser".equals(authentication.getPrincipal()) && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails userDetails = (CustomUserDetails)authentication.getPrincipal();
            userId = userDetails.getUser().getId();
        }
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \ubaa9\ub85d \uc870\ud68c \uc694\uccad: votePostId={}, sort={}, cursor={}, size={}, userId={}", new Object[]{votePostId, sort, cursor != null ? "present" : "null", size, userId != null ? userId : "anonymous"});
        VoteboardCommentCursorResponse response = this.commentService.getCommentsByCursor(votePostId, sort, size, cursor, userId);
        log.debug("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \ubaa9\ub85d \uc870\ud68c \uc644\ub8cc: resultCount={}, hasNext={}", (Object)response.getComments().size(), (Object)response.isHasNext());
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="\ub313\uae00 \uc218\uc815", description="\uc791\uc131\ud55c \ub313\uae00\uc744 \uc218\uc815\ud569\ub2c8\ub2e4.\n\n**\uc218\uc815 \uc81c\ud55c\uc0ac\ud56d:**\n- \uc791\uc131\uc790 \ubcf8\uc778\ub9cc \uc218\uc815 \uac00\ub2a5\n- \uc0ad\uc81c\ub41c \ub313\uae00\uc740 \uc218\uc815 \ubd88\uac00\n- \ub0b4\uc6a9\ub9cc \uc218\uc815 \uac00\ub2a5 (\ub300\ub313\uae00 \uad00\uacc4\ub294 \ubcc0\uacbd \ubd88\uac00)\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc218\uc815 \uc131\uacf5", content={@Content(schema=@Schema(implementation=VoteboardCommentCreateResponse.class))}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ube48 \ub0b4\uc6a9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[content] \ub313\uae00 \ub0b4\uc6a9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ub313\uae00 \uae38\uc774 \ucd08\uacfc", value="{\"code\": \"COMMENT_CONTENT_TOO_LONG\", \"message\": \"\ub313\uae00\uc774 \ub108\ubb34 \uae41\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"COMMENT_ACCESS_DENIED\", \"message\": \"\ub313\uae00\uc5d0 \ub300\ud55c \uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ub313\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"COMMENT_NOT_FOUND\", \"message\": \"\ub313\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @PatchMapping(value={"/{commentId}"})
    public ResponseEntity<?> updateComment(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long votePostId, @Parameter(description="\ub313\uae00 ID", example="456") @PathVariable Long commentId, @RequestBody @Valid VoteboardCommentUpdateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc218\uc815 \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: votePostId={}, commentId={}", (Object)votePostId, (Object)commentId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc218\uc815 \uc694\uccad: votePostId={}, commentId={}, userId={}", new Object[]{votePostId, commentId, userDetails.getUser().getId()});
        String userId = userDetails.getUser().getId();
        VoteboardCommentCreateResponse response = this.commentService.updateComment(votePostId, commentId, request, userId);
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc218\uc815 \uc644\ub8cc: commentId={}", (Object)response.getCommentId());
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="\ub313\uae00 \uc0ad\uc81c (\uc18c\ud504\ud2b8 \uc0ad\uc81c)", description="\ub313\uae00\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4. (\uc18c\ud504\ud2b8 \uc0ad\uc81c)\n\n**\uc0ad\uc81c \ud2b9\uc9d5:**\n- \uc2e4\uc81c\ub85c\ub294 deleted \ud50c\ub798\uadf8\ub9cc true\ub85c \ubcc0\uacbd\n- \uc0ad\uc81c\ub41c \ub313\uae00\uc740 \"\uc0ad\uc81c\ub41c \ub313\uae00\uc785\ub2c8\ub2e4\" \ud45c\uc2dc\n- \ub300\ub313\uae00\uc774 \uc788\ub294 \ubd80\ubaa8 \ub313\uae00\ub3c4 \uc0ad\uc81c \uac00\ub2a5\n- \uc791\uc131\uc790 \ubcf8\uc778\ub9cc \uc0ad\uc81c \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="\uc0ad\uc81c \uc131\uacf5"), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uc0ad\uc81c \uad8c\ud55c \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"COMMENT_ACCESS_DENIED\", \"message\": \"\ub313\uae00\uc5d0 \ub300\ud55c \uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ub313\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"COMMENT_NOT_FOUND\", \"message\": \"\ub313\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @DeleteMapping(value={"/{commentId}"})
    public ResponseEntity<?> deleteComment(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long votePostId, @Parameter(description="\ub313\uae00 ID", example="456") @PathVariable Long commentId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc0ad\uc81c \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: votePostId={}, commentId={}", (Object)votePostId, (Object)commentId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc0ad\uc81c \uc694\uccad: votePostId={}, commentId={}, userId={}", new Object[]{votePostId, commentId, userDetails.getUser().getId()});
        String userId = userDetails.getUser().getId();
        this.commentService.deleteComment(votePostId, commentId, userId);
        log.info("\ud22c\ud45c\uac8c\uc2dc\ud310 \ub313\uae00 \uc0ad\uc81c \uc644\ub8cc: commentId={}", (Object)commentId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public VoteboardCommentController(VoteboardCommentService commentService) {
        this.commentService = commentService;
    }
}

