/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.domain.dto;

import com.example.soso.community.voteboard.domain.dto.VoteOptionResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostCreateRequest;
import com.example.soso.community.voteboard.domain.dto.VotePostDetailResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostListResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostSummaryResponse;
import com.example.soso.community.voteboard.domain.entity.VoteOption;
import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.community.voteboard.domain.entity.VotePostImage;
import com.example.soso.community.voteboard.domain.entity.VoteResult;
import com.example.soso.users.domain.dto.UserMapper;
import com.example.soso.users.domain.entity.Users;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class VotePostMapper {
    private final UserMapper userMapper;

    public VotePost toEntity(VotePostCreateRequest request, Users user) {
        VotePost votePost = VotePost.create((Users)user, (String)request.getTitle(), (String)request.getContent(), (LocalDateTime)request.getEndTime(), (boolean)request.getAllowRevote());
        List<VoteOption> options = request.getVoteOptions().stream().map(optionRequest -> VoteOption.builder().votePost(votePost).content(optionRequest.getContent()).sequence(request.getVoteOptions().indexOf(optionRequest)).build()).toList();
        votePost.addVoteOptions(options);
        return votePost;
    }

    public VotePostSummaryResponse toSummaryResponse(VotePost votePost, long commentCount, long likeCount, boolean isLiked) {
        List<VoteOptionResponse> voteOptions = votePost.getVoteOptions().stream().limit(3L).map(option -> this.toVoteOptionResponse(option, votePost.getTotalVotes())).toList();
        return VotePostSummaryResponse.builder().id(votePost.getId()).title(votePost.getTitle()).author(this.userMapper.toUserSummary(votePost.getUser())).viewCount(votePost.getViewCount()).commentCount(commentCount).totalVotes(votePost.getTotalVotes()).voteStatus(votePost.getVoteStatus()).endTime(votePost.getEndTime()).allowRevote(votePost.isAllowRevote()).voteOptions(voteOptions).likeCount(likeCount).isLiked(isLiked).createdDate(votePost.getCreatedDate()).lastModifiedDate(votePost.getLastModifiedDate()).build();
    }

    public VotePostDetailResponse toDetailResponse(VotePost votePost, long commentCount, VoteResult userVoteResult, long likeCount, boolean isLiked) {
        return VotePostDetailResponse.builder().id(votePost.getId()).title(votePost.getTitle()).content(votePost.getContent()).author(this.userMapper.toUserSummary(votePost.getUser())).imageUrls(votePost.getImages().stream().map(VotePostImage::getImageUrl).toList()).voteOptions(votePost.getVoteOptions().stream().map(option -> this.toVoteOptionResponse(option, votePost.getTotalVotes())).toList()).selectedOptionId(userVoteResult != null ? userVoteResult.getVoteOption().getId() : null).totalVotes(votePost.getTotalVotes()).voteStatus(votePost.getVoteStatus()).endTime(votePost.getEndTime()).allowRevote(votePost.isAllowRevote()).viewCount(votePost.getViewCount()).commentCount(commentCount).likeCount(likeCount).isLiked(isLiked).createdDate(votePost.getCreatedDate()).lastModifiedDate(votePost.getLastModifiedDate()).build();
    }

    public VoteOptionResponse toVoteOptionResponse(VoteOption option, int totalVotes) {
        return VoteOptionResponse.builder().id(option.getId()).content(option.getContent()).sequence(option.getSequence()).voteCount(option.getVoteCount()).percentage(option.calculatePercentage(totalVotes)).build();
    }

    public VotePostListResponse toListResponse(List<VotePostSummaryResponse> posts, Long nextCursor, boolean hasNext) {
        return VotePostListResponse.builder().posts(posts).nextCursor(nextCursor).hasNext(hasNext).size(posts.size()).build();
    }

    @Generated
    public VotePostMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }
}

