/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.controller;

import com.example.soso.global.jwt.JwtTokenDto;
import com.example.soso.users.service.AuthService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Auth", description="\uc778\uc99d/\uc778\uac00 \uad00\ub828 API")
@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    private final AuthService authService;

    @Operation(summary="Access Token \uc7ac\ubc1c\uae09", description="Refresh Token \ucfe0\ud0a4\uac00 \uc720\ud6a8\ud558\uba74 \uc0c8\ub85c\uc6b4 Access Token\uacfc Refresh Token\uc744 \ubc1c\uae09\ud569\ub2c8\ub2e4.\n\n**RTR (Refresh Token Rotation):**\n- \uae30\uc874 Refresh Token \ubb34\ud6a8\ud654\n- \uc0c8\ub85c\uc6b4 Access Token, Refresh Token \ubc1c\uae09\n\n**\ud1a0\ud070 \ubc1c\uae09 \ubc29\uc2dd:**\n- Response Body: accessToken \ud3ec\ud568 (\uae30\uc874 \ud638\ud658\uc131 \uc720\uc9c0)\n- Set-Cookie \ud5e4\ub354: accessToken, refreshToken \ucfe0\ud0a4 \uc124\uc815 (SSR \uc9c0\uc6d0)\n", responses={@ApiResponse(responseCode="200", description="\ud1a0\ud070 \uc7ac\ubc1c\uae09 \uc131\uacf5", content={@Content(schema=@Schema(implementation=JwtTokenDto.class))}), @ApiResponse(responseCode="401", description="Refresh Token\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc74c", content={@Content(schema=@Schema(ref="#/components/schemas/ErrorResponse"))})})
    @PostMapping(value={"/refresh"})
    public ResponseEntity<JwtTokenDto> refreshToken(@Parameter(description="HttpOnly \ucfe0\ud0a4\uc5d0 \uc800\uc7a5\ub41c Refresh Token", example="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...") @CookieValue(value="refreshToken", required=false) String refreshToken, HttpServletResponse response) {
        if (refreshToken == null) {
            return ResponseEntity.badRequest().build();
        }
        JwtTokenDto jwtToken = this.authService.refreshAccessToken(refreshToken, response);
        return ResponseEntity.ok((Object)jwtToken);
    }

    @Operation(summary="\ub85c\uadf8\uc544\uc6c3", description="Refresh Token\uc744 \ubb34\ud6a8\ud654\ud558\uace0 \ucfe0\ud0a4\ub97c \uc0ad\uc81c\ud569\ub2c8\ub2e4.\n\n**\ub3d9\uc791:**\n- Redis\uc5d0\uc11c Refresh Token \uc0ad\uc81c\n- Access Token \ucfe0\ud0a4 \uc0ad\uc81c\n- Refresh Token \ucfe0\ud0a4 \uc0ad\uc81c\n", responses={@ApiResponse(responseCode="200", description="\ub85c\uadf8\uc544\uc6c3 \uc131\uacf5"), @ApiResponse(responseCode="400", description="Refresh Token\uc774 \uc5c6\uc74c")})
    @PostMapping(value={"/logout"})
    public ResponseEntity<Void> logout(@Parameter(description="HttpOnly \ucfe0\ud0a4\uc5d0 \uc800\uc7a5\ub41c Refresh Token") @CookieValue(value="refreshToken", required=false) String refreshToken, HttpServletResponse response) {
        if (refreshToken == null) {
            return ResponseEntity.badRequest().build();
        }
        this.authService.logout(refreshToken, response);
        return ResponseEntity.ok().build();
    }

    @Generated
    public AuthController(AuthService authService) {
        this.authService = authService;
    }
}

