/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.scheduler;

import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CommentLikeScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommentLikeScheduler.class);
    private final RedisTemplate<String, String> redisTemplate;
    private final CommentRepository commentRepository;
    private static final String COMMENT_LIKE_COUNT_PREFIX = "comment:like:count:";

    @Scheduled(cron="0 0/10 * * * *")
    @Transactional
    public void syncCommentLikeCountToDB() {
        log.info("\ub313\uae00 \uc88b\uc544\uc694 \uc218 \ub3d9\uae30\ud654 \uc2dc\uc791");
        Set keys = this.redisTemplate.keys((Object)"comment:like:count:*");
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            try {
                String commentIdStr = key.replace(COMMENT_LIKE_COUNT_PREFIX, "");
                Long commentId = Long.parseLong(commentIdStr);
                String countStr = (String)this.redisTemplate.opsForValue().get((Object)key);
                if (countStr == null) continue;
                long likeCount = Long.parseLong(countStr);
                this.commentRepository.updateLikeCount(commentId, likeCount);
            }
            catch (Exception e) {
                log.error("\ub313\uae00 \uc88b\uc544\uc694 \ub3d9\uae30\ud654 \uc2e4\ud328: {}", (Object)key, (Object)e);
            }
        }
        log.info("\ub313\uae00 \uc88b\uc544\uc694 \uc218 \ub3d9\uae30\ud654 \uc644\ub8cc");
    }

    @Generated
    public CommentLikeScheduler(RedisTemplate<String, String> redisTemplate, CommentRepository commentRepository) {
        this.redisTemplate = redisTemplate;
        this.commentRepository = commentRepository;
    }
}

