/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.freeboard.post.service;

import com.example.soso.community.common.likes.repository.PostLikeRepository;
import com.example.soso.community.common.post.domain.dto.PostSortType;
import com.example.soso.community.common.post.domain.dto.PostSummaryResponse;
import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.common.post.domain.entity.Post;
import com.example.soso.community.common.post.domain.entity.PostImage;
import com.example.soso.community.common.post.repository.PostImageRepository;
import com.example.soso.community.common.post.repository.PostRepository;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCreateRequest;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCreateResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCursorResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardDetailResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardSortType;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardUpdateRequest;
import com.example.soso.community.freeboard.post.service.FreeboardService;
import com.example.soso.community.freeboard.post.service.FreeboardServiceImpl;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.image.service.ImageUploadService;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class FreeboardServiceImpl
implements FreeboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FreeboardServiceImpl.class);
    private final PostRepository postRepository;
    private final PostImageRepository postImageRepository;
    private final UsersRepository usersRepository;
    private final PostLikeRepository postLikeRepository;
    private final ImageUploadService imageUploadService;
    private final ObjectMapper objectMapper;
    private static final String FREEBOARD_DIRECTORY = "freeboard";
    private static final int CONTENT_PREVIEW_LENGTH = 100;

    @Transactional
    public FreeboardCreateResponse createPost(FreeboardCreateRequest request, String userId) {
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131 \uc2dc\uc791: userId={}, category={}", (Object)userId, (Object)request.getCategory());
        Users user = this.findUserById(userId);
        Post post = Post.builder().user(user).category(request.getCategory()).title(request.getTitle()).content(request.getContent()).likeCount(0).commentCount(0).build();
        Post savedPost = (Post)this.postRepository.save((Object)post);
        if (request.getImages() != null && !request.getImages().isEmpty()) {
            List imageUrls = this.imageUploadService.uploadImages(request.getImages(), FREEBOARD_DIRECTORY);
            this.savePostImages(savedPost, imageUrls);
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131 \uc644\ub8cc: postId={}, imageCount={}", (Object)savedPost.getId(), (Object)savedPost.getImages().size());
        return new FreeboardCreateResponse(savedPost.getId());
    }

    @Transactional
    public FreeboardDetailResponse getPost(Long postId, String userId) {
        log.debug("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc870\ud68c: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = (Post)this.postRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
        post.increaseViewCount();
        boolean isAuthorized = userId != null;
        List<FreeboardDetailResponse.ImageInfo> images = post.getImages().stream().sorted((img1, img2) -> Integer.compare(img1.getSequence(), img2.getSequence())).map(img -> FreeboardDetailResponse.ImageInfo.builder().imageId(img.getId()).imageUrl(img.getImageUrl()).sequence(img.getSequence()).build()).toList();
        boolean isAuthor = userId != null && post.getUser().getId().equals(userId);
        FreeboardDetailResponse.FreeboardDetailResponseBuilder builder = FreeboardDetailResponse.builder().postId(post.getId()).author(FreeboardDetailResponse.PostDetailAuthorInfo.builder().userId(post.getUser().getId()).nickname(post.getUser().getNickname()).profileImageUrl(post.getUser().getProfileImageUrl()).userType(post.getUser().getUserType()).address(post.getUser().getLocation()).build()).category(post.getCategory()).title(post.getTitle()).content(post.getContent()).images(images).likeCount(post.getLikeCount()).commentCount(post.getCommentCount()).viewCount(post.getViewCount()).createdAt(post.getCreatedAt()).updatedAt(post.getUpdatedAt()).isAuthorized(isAuthorized).isAuthor(isAuthor);
        if (isAuthorized) {
            boolean isLiked = this.postLikeRepository.existsByPost_IdAndUser_Id(postId, userId);
            builder.isLiked(Boolean.valueOf(isLiked)).canEdit(Boolean.valueOf(isAuthor)).canDelete(Boolean.valueOf(isAuthor));
        } else {
            builder.isLiked(null).canEdit(null).canDelete(null);
        }
        return builder.build();
    }

    public FreeboardCursorResponse getPostsByCursor(Category category, FreeboardSortType sort, int size, String cursor, String userId) {
        boolean hasNext;
        log.debug("\uc790\uc720\uac8c\uc2dc\ud310 \ubaa9\ub85d \uc870\ud68c: category={}, sort={}, size={}, userId={}", new Object[]{category, sort, size, userId});
        if (size > 50) {
            size = 50;
        }
        if (size < 1) {
            size = 10;
        }
        CursorInfo cursorInfo = this.parseCursor(cursor, sort);
        PostSortType postSortType = this.convertToPostSortType(sort);
        List postSummaries = this.postRepository.findAllByCursorPaging(category, postSortType, size + 1, cursorInfo.lastValue(), cursorInfo.lastId(), userId);
        long totalCount = category != null ? this.postRepository.countByCategoryAndDeletedFalse(category) : this.postRepository.countByDeletedFalse();
        boolean bl = hasNext = postSummaries.size() > size;
        if (hasNext) {
            postSummaries = postSummaries.subList(0, size);
        }
        List<FreeboardCursorResponse.FreeboardSummary> summaries = postSummaries.stream().map(arg_0 -> this.convertToFreeboardSummary(arg_0)).toList();
        String nextCursor = null;
        if (hasNext && !postSummaries.isEmpty()) {
            PostSummaryResponse lastPost = (PostSummaryResponse)postSummaries.get(postSummaries.size() - 1);
            nextCursor = this.generateCursorFromPostSummary(lastPost, sort);
        }
        return FreeboardCursorResponse.builder().posts(summaries).hasNext(hasNext).nextCursor(nextCursor).size(summaries.size()).totalCount(totalCount).isAuthorized(userId != null).build();
    }

    @Transactional
    public FreeboardCreateResponse updatePost(Long postId, FreeboardUpdateRequest request, String userId) {
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815 \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = this.findPostByIdAndUserId(postId, userId);
        if (request.getDeleteImageIds() != null && !request.getDeleteImageIds().isEmpty()) {
            this.deletePostImages(post, request.getDeleteImageIds());
        }
        List newImageUrls = Collections.emptyList();
        if (request.getImages() != null && !request.getImages().isEmpty()) {
            int newImageCount;
            int currentImageCount = post.getImages().size();
            if (currentImageCount + (newImageCount = request.getImages().size()) > this.imageUploadService.getMaxImageCount()) {
                throw new IllegalArgumentException("\ucd1d \uc774\ubbf8\uc9c0 \uac1c\uc218\ub294 " + this.imageUploadService.getMaxImageCount() + "\uac1c\ub97c \ucd08\uacfc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            newImageUrls = this.imageUploadService.uploadImages(request.getImages(), FREEBOARD_DIRECTORY);
            this.savePostImages(post, newImageUrls);
        }
        this.updatePostFields(post, request);
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815 \uc644\ub8cc: postId={}, newImageCount={}", (Object)postId, (Object)newImageUrls.size());
        return new FreeboardCreateResponse(postId);
    }

    @Transactional
    public void deletePost(Long postId, String userId) {
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc18c\ud504\ud2b8 \uc0ad\uc81c: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = this.findPostByIdAndUserId(postId, userId);
        post.delete();
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc18c\ud504\ud2b8 \uc0ad\uc81c \uc644\ub8cc: postId={}", (Object)postId);
    }

    @Transactional
    public void hardDeletePost(Long postId, String userId) {
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \ud558\ub4dc \uc0ad\uc81c \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        Post post = this.findPostByIdAndUserId(postId, userId);
        List<String> imageUrls = post.getImages().stream().map(PostImage::getImageUrl).toList();
        if (!imageUrls.isEmpty()) {
            this.imageUploadService.deleteImages(imageUrls);
        }
        this.postRepository.delete((Object)post);
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \ud558\ub4dc \uc0ad\uc81c \uc644\ub8cc: postId={}, deletedImageCount={}", (Object)postId, (Object)imageUrls.size());
    }

    private Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    private Post findPostByIdAndUserId(Long postId, String userId) {
        Post post = (Post)this.postRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
        if (!post.getUser().getId().equals(userId)) {
            throw new PostException((BaseErrorCode)PostErrorCode.POST_ACCESS_DENIED);
        }
        return post;
    }

    private void savePostImages(Post post, List<String> imageUrls) {
        for (String imageUrl : imageUrls) {
            PostImage postImage = PostImage.builder().post(post).imageUrl(imageUrl).build();
            post.addImage(postImage);
        }
    }

    private void deletePostImages(Post post, List<Long> deleteImageIds) {
        List<PostImage> imagesToDelete = post.getImages().stream().filter(image -> deleteImageIds.contains(image.getId())).toList();
        for (PostImage image2 : imagesToDelete) {
            this.imageUploadService.deleteImage(image2.getImageUrl());
            post.getImages().remove(image2);
        }
    }

    private void updatePostFields(Post post, FreeboardUpdateRequest request) {
        ArrayList newImages = new ArrayList(post.getImages());
        post.update(StringUtils.hasText((String)request.getTitle()) ? request.getTitle() : post.getTitle(), StringUtils.hasText((String)request.getContent()) ? request.getContent() : post.getContent(), request.getCategory() != null ? request.getCategory() : post.getCategory(), newImages);
    }

    private CursorInfo parseCursor(String cursor, FreeboardSortType sort) {
        if (!StringUtils.hasText((String)cursor)) {
            return new CursorInfo(null, null);
        }
        try {
            String decodedCursor = new String(Base64.getDecoder().decode(cursor), StandardCharsets.UTF_8);
            JsonNode jsonNode = this.objectMapper.readTree(decodedCursor);
            JsonNode idNode = jsonNode.get("id");
            JsonNode sortValueNode = jsonNode.get("sortValue");
            if (idNode == null || !idNode.isNumber() || sortValueNode == null || sortValueNode.isNull()) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_CURSOR);
            }
            long id = idNode.asLong();
            String sortValue = sortValueNode.asText();
            if (!StringUtils.hasText((String)sortValue) || !this.isValidSortValue(sort, sortValue)) {
                throw new PostException((BaseErrorCode)PostErrorCode.INVALID_CURSOR);
            }
            log.debug("\ucee4\uc11c \ud30c\uc2f1 \uc131\uacf5: id={}, sortValue={}", (Object)id, (Object)sortValue);
            return new CursorInfo(Long.valueOf(id), sortValue);
        }
        catch (IllegalArgumentException e) {
            log.warn("\ucee4\uc11c Base64 \ub514\ucf54\ub529 \uc2e4\ud328: cursor={}, error={}", (Object)cursor, (Object)e.getMessage());
            throw new PostException((BaseErrorCode)PostErrorCode.INVALID_CURSOR);
        }
        catch (PostException e) {
            log.warn("\ucee4\uc11c \ud30c\uc2f1 \uc2e4\ud328: cursor={}, error={}", (Object)cursor, (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.warn("\ucee4\uc11c \ud30c\uc2f1 \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc624\ub958: cursor={}, error={}", (Object)cursor, (Object)e.getMessage());
            throw new PostException((BaseErrorCode)PostErrorCode.INVALID_CURSOR);
        }
    }

    private boolean isValidSortValue(FreeboardSortType sort, String sortValue) {
        return switch (1.$SwitchMap$com$example$soso$community$freeboard$post$domain$dto$FreeboardSortType[sort.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> this.isParsableDate(sortValue);
            case 2 -> this.isParsableNumber(sortValue);
            case 3, 4 -> this.isParsableNumber(sortValue);
        };
    }

    private boolean isParsableDate(String value) {
        try {
            LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isParsableNumber(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private PostSortType convertToPostSortType(FreeboardSortType freeboardSortType) {
        return switch (1.$SwitchMap$com$example$soso$community$freeboard$post$domain$dto$FreeboardSortType[freeboardSortType.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> PostSortType.LATEST;
            case 3 -> PostSortType.LIKE;
            case 4 -> PostSortType.COMMENT;
            case 2 -> PostSortType.VIEW;
        };
    }

    private FreeboardCursorResponse.FreeboardSummary convertToFreeboardSummary(PostSummaryResponse postSummary) {
        FreeboardCursorResponse.PostAuthorInfo authorInfo = null;
        if (postSummary.user() != null) {
            authorInfo = FreeboardCursorResponse.PostAuthorInfo.builder().userId(postSummary.user().userId()).nickname(postSummary.user().nickname()).profileImageUrl(postSummary.user().profileImageUrl()).userType(postSummary.user().userType()).build();
        }
        String contentPreview = postSummary.content() != null && postSummary.content().length() > 100 ? postSummary.content().substring(0, 100) + "..." : postSummary.content();
        return FreeboardCursorResponse.FreeboardSummary.builder().postId(postSummary.postId()).author(authorInfo).category(postSummary.category()).title(postSummary.title()).contentPreview(contentPreview).likeCount(postSummary.likeCount()).commentCount(postSummary.commentCount()).isLiked(postSummary.likeByPost()).createdAt(postSummary.createdAt()).viewCount(postSummary.viewCount()).thumbnailUrl(postSummary.thumbnailUrl()).imageCount(postSummary.imageCount() != null ? postSummary.imageCount() : 0).updatedAt(postSummary.updatedAt()).build();
    }

    private Sort createSort(FreeboardSortType sortType) {
        return switch (1.$SwitchMap$com$example$soso$community$freeboard$post$domain$dto$FreeboardSortType[sortType.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"});
            case 3 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"likeCount", "createdAt"});
            case 4 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"commentCount", "createdAt"});
            case 2 -> Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"viewCount", "createdAt"});
        };
    }

    private Set<Long> getLikedPostIds(List<Post> posts, String userId) {
        if (userId == null || posts.isEmpty()) {
            return Collections.emptySet();
        }
        List<Long> postIds = posts.stream().map(Post::getId).toList();
        return this.postLikeRepository.findPostIdsByPostIdsAndUserId(postIds, userId);
    }

    private FreeboardCursorResponse.FreeboardSummary createFreeboardSummary(Post post, boolean isLiked) {
        List<String> imageUrls = post.getImages().stream().map(PostImage::getImageUrl).toList();
        String contentPreview = this.createContentPreview(post.getContent());
        String thumbnailUrl = imageUrls.isEmpty() ? null : imageUrls.get(0);
        return FreeboardCursorResponse.FreeboardSummary.builder().postId(post.getId()).author(FreeboardCursorResponse.PostAuthorInfo.builder().userId(post.getUser().getId()).nickname(post.getUser().getNickname()).profileImageUrl(post.getUser().getProfileImageUrl()).build()).category(post.getCategory()).title(post.getTitle()).contentPreview(contentPreview).thumbnailUrl(thumbnailUrl).imageCount(imageUrls.size()).likeCount(post.getLikeCount()).commentCount(post.getCommentCount()).viewCount(post.getViewCount()).isLiked(Boolean.valueOf(isLiked)).createdAt(post.getCreatedAt()).updatedAt(post.getUpdatedAt()).build();
    }

    private String createContentPreview(String content) {
        if (content == null || content.length() <= 100) {
            return content;
        }
        return content.substring(0, 100) + "...";
    }

    private String generateCursor(Post post, FreeboardSortType sort) {
        try {
            String cursorValue = switch (1.$SwitchMap$com$example$soso$community$freeboard$post$domain$dto$FreeboardSortType[sort.ordinal()]) {
                default -> throw new MatchException(null, null);
                case 1 -> post.getCreatedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                case 3 -> String.valueOf(post.getLikeCount());
                case 4 -> String.valueOf(post.getCommentCount());
                case 2 -> String.valueOf(post.getViewCount());
            };
            Map<String, String> cursorData = Map.of("id", post.getId(), "sortValue", cursorValue);
            String jsonString = this.objectMapper.writeValueAsString(cursorData);
            return Base64.getEncoder().encodeToString(jsonString.getBytes());
        }
        catch (Exception e) {
            log.warn("\ucee4\uc11c \uc0dd\uc131 \uc2e4\ud328: postId={}, sort={}, error={}", new Object[]{post.getId(), sort, e.getMessage()});
            return null;
        }
    }

    private String generateCursorFromPostSummary(PostSummaryResponse postSummary, FreeboardSortType sort) {
        try {
            String cursorValue = switch (1.$SwitchMap$com$example$soso$community$freeboard$post$domain$dto$FreeboardSortType[sort.ordinal()]) {
                default -> throw new MatchException(null, null);
                case 1 -> postSummary.createdAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                case 3 -> String.valueOf(postSummary.likeCount());
                case 4 -> String.valueOf(postSummary.commentCount());
                case 2 -> String.valueOf(postSummary.viewCount());
            };
            Map<String, String> cursorData = Map.of("id", postSummary.postId(), "sortValue", cursorValue);
            String jsonString = this.objectMapper.writeValueAsString(cursorData);
            return Base64.getEncoder().encodeToString(jsonString.getBytes());
        }
        catch (Exception e) {
            log.warn("\ucee4\uc11c \uc0dd\uc131 \uc2e4\ud328: postId={}, sort={}, error={}", new Object[]{postSummary.postId(), sort, e.getMessage()});
            return null;
        }
    }

    @Generated
    public FreeboardServiceImpl(PostRepository postRepository, PostImageRepository postImageRepository, UsersRepository usersRepository, PostLikeRepository postLikeRepository, ImageUploadService imageUploadService, ObjectMapper objectMapper) {
        this.postRepository = postRepository;
        this.postImageRepository = postImageRepository;
        this.usersRepository = usersRepository;
        this.postLikeRepository = postLikeRepository;
        this.imageUploadService = imageUploadService;
        this.objectMapper = objectMapper;
    }
}

