/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.domain.entity;

import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.votesboard.domain.entity.VoteOption;
import com.example.soso.community.votesboard.domain.entity.VoteStatus;
import com.example.soso.community.votesboard.domain.entity.VotesboardImage;
import com.example.soso.global.time.BaseTimeEntity;
import com.example.soso.users.domain.entity.Users;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="votesboard")
public class Votesboard
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private Users user;
    @Column(nullable=false, length=100)
    private String title;
    @Lob
    @Column(nullable=false)
    private String content;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=50)
    private Category category;
    @OneToMany(mappedBy="votesboard", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence ASC")
    private List<VotesboardImage> images = new ArrayList();
    @Column(name="view_count", nullable=false)
    private int viewCount = 0;
    @Column(name="like_count", nullable=false)
    private int likeCount = 0;
    @Column(name="comment_count", nullable=false)
    private int commentCount = 0;
    @Column(nullable=false)
    private boolean deleted = false;
    @OneToMany(mappedBy="votesboard", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence ASC")
    private List<VoteOption> voteOptions = new ArrayList();
    @Column(name="end_time", nullable=false)
    private LocalDateTime endTime;
    @Column(name="allow_revote", nullable=false)
    private boolean allowRevote = false;
    @Column(name="allow_multiple_choice", nullable=false)
    private boolean allowMultipleChoice = false;
    @Column(name="total_votes", nullable=false)
    private int totalVotes = 0;

    public static Votesboard create(Users user, String title, String content, Category category, LocalDateTime endTime, boolean allowRevote, boolean allowMultipleChoice) {
        Votesboard votesboard = new Votesboard();
        votesboard.user = user;
        votesboard.title = title;
        votesboard.content = content;
        votesboard.category = category;
        votesboard.endTime = endTime;
        votesboard.allowRevote = allowRevote;
        votesboard.allowMultipleChoice = allowMultipleChoice;
        votesboard.totalVotes = 0;
        votesboard.viewCount = 0;
        votesboard.deleted = false;
        return votesboard;
    }

    public void addVoteOption(VoteOption option) {
        this.voteOptions.add(option);
        option.setVotesboard(this);
    }

    public void addVoteOptions(List<VoteOption> options) {
        for (VoteOption option : options) {
            this.addVoteOption(option);
        }
    }

    public void increaseTotalVotes() {
        ++this.totalVotes;
    }

    public void decreaseTotalVotes() {
        if (this.totalVotes > 0) {
            --this.totalVotes;
        }
    }

    public boolean isActive() {
        return LocalDateTime.now().isBefore(this.endTime) && !this.isDeleted();
    }

    public VoteStatus getVoteStatus() {
        if (this.isDeleted()) {
            return VoteStatus.DELETED;
        }
        return this.isActive() ? VoteStatus.IN_PROGRESS : VoteStatus.COMPLETED;
    }

    public void addImage(VotesboardImage image) {
        this.images.add(image);
        image.setVotesboard(this);
    }

    public void updatePost(String title, String content, Category category) {
        if (title != null) {
            this.title = title;
        }
        if (content != null) {
            this.content = content;
        }
        if (category != null) {
            this.category = category;
        }
    }

    public void updateVoteSettings(LocalDateTime endTime, boolean allowRevote, boolean allowMultipleChoice) {
        if (this.totalVotes == 0) {
            this.endTime = endTime;
            this.allowRevote = allowRevote;
            this.allowMultipleChoice = allowMultipleChoice;
        }
    }

    public void increaseViewCount() {
        ++this.viewCount;
    }

    public void updateLikeCount(int redisLikeCount) {
        this.likeCount = redisLikeCount;
    }

    public void updateCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    public void delete() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Users getUser() {
        return this.user;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public List<VotesboardImage> getImages() {
        return this.images;
    }

    @Generated
    public int getViewCount() {
        return this.viewCount;
    }

    @Generated
    public int getLikeCount() {
        return this.likeCount;
    }

    @Generated
    public int getCommentCount() {
        return this.commentCount;
    }

    @Generated
    public List<VoteOption> getVoteOptions() {
        return this.voteOptions;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public boolean isAllowRevote() {
        return this.allowRevote;
    }

    @Generated
    public boolean isAllowMultipleChoice() {
        return this.allowMultipleChoice;
    }

    @Generated
    public int getTotalVotes() {
        return this.totalVotes;
    }

    @Generated
    protected Votesboard() {
    }
}

