/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.redis;

import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.util.PostException;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PostLikeRedisRepository {
    private final RedisTemplate<String, String> redisTemplate;
    private static final String LIKE_SET_KEY_PREFIX = "post:likes:";
    private static final String LIKE_COUNT_KEY_PREFIX = "post:likeCount:";

    public boolean isLiked(Long postId, String userId) {
        return Boolean.TRUE.equals(this.redisTemplate.opsForSet().isMember((Object)this.getSetKey(postId), (Object)userId));
    }

    public void addLike(Long postId, String userId) {
        this.redisTemplate.opsForSet().add((Object)this.getSetKey(postId), (Object[])new String[]{userId});
        this.redisTemplate.opsForValue().increment((Object)this.getCountKey(postId));
    }

    public void removeLike(Long postId, String userId) {
        this.redisTemplate.opsForSet().remove((Object)this.getSetKey(postId), new Object[]{userId});
        this.redisTemplate.opsForValue().decrement((Object)this.getCountKey(postId));
    }

    public long getLikeCount(Long postId) {
        String count = (String)this.redisTemplate.opsForValue().get((Object)this.getCountKey(postId));
        if (count == null) {
            throw new PostException((BaseErrorCode)PostErrorCode.LIKE_COUNT_NOT_FOUND);
        }
        return Long.parseLong(count);
    }

    private String getSetKey(Long postId) {
        return LIKE_SET_KEY_PREFIX + postId;
    }

    private String getCountKey(Long postId) {
        return LIKE_COUNT_KEY_PREFIX + postId;
    }

    public Set<Long> getAllPostIdsWithLikes() {
        Set keys = this.redisTemplate.keys((Object)"like:count:*");
        if (keys == null) {
            return Set.of();
        }
        return keys.stream().map(key -> Long.parseLong(key.replace("like:count:", ""))).collect(Collectors.toSet());
    }

    @Generated
    public PostLikeRedisRepository(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

