/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.repository;

import com.example.soso.community.votesboard.domain.entity.QVotesboard;
import com.example.soso.community.votesboard.domain.entity.VoteStatus;
import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.dto.VotesboardSortType;
import com.example.soso.community.votesboard.repository.VotesboardRepositoryCustom;
import com.example.soso.community.votesboard.repository.VotesboardRepositoryImpl;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Repository;

@Repository
public class VotesboardRepositoryImpl
implements VotesboardRepositoryCustom {
    private final JPAQueryFactory queryFactory;

    public List<Votesboard> findAllBySortAndCursor(VoteStatus status, VotesboardSortType sort, Long cursor, int size) {
        QVotesboard votesboard = QVotesboard.votesboard;
        LocalDateTime now = LocalDateTime.now();
        BooleanBuilder condition = new BooleanBuilder();
        condition.and((Predicate)votesboard.deleted.eq(Boolean.valueOf(false)));
        if (status == VoteStatus.IN_PROGRESS) {
            condition.and((Predicate)votesboard.endTime.gt((Comparable)now));
        } else if (status == VoteStatus.COMPLETED) {
            condition.and((Predicate)votesboard.endTime.loe((Comparable)now));
        }
        if (cursor != null) {
            condition.and((Predicate)this.getCursorCondition(votesboard, sort, cursor));
        }
        OrderSpecifier[] orderSpecifiers = this.getOrderSpecifiers(votesboard, sort);
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.queryFactory.selectFrom((EntityPath)votesboard).where((Predicate)condition)).orderBy(orderSpecifiers)).limit((long)(size + 1))).fetch();
    }

    private BooleanExpression getCursorCondition(QVotesboard votesboard, VotesboardSortType sort, Long cursorId) {
        return votesboard.id.lt((Number)cursorId);
    }

    private OrderSpecifier<?>[] getOrderSpecifiers(QVotesboard votesboard, VotesboardSortType sort) {
        switch (1.$SwitchMap$com$example$soso$community$votesboard$dto$VotesboardSortType[sort.ordinal()]) {
            case 1: {
                return new OrderSpecifier[]{votesboard.totalVotes.desc(), votesboard.id.desc()};
            }
            case 2: {
                return new OrderSpecifier[]{votesboard.commentCount.desc(), votesboard.id.desc()};
            }
            case 3: {
                return new OrderSpecifier[]{votesboard.viewCount.desc(), votesboard.id.desc()};
            }
        }
        return new OrderSpecifier[]{votesboard.id.desc()};
    }

    @Generated
    public VotesboardRepositoryImpl(JPAQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }
}

