/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.votesboard.service;

import com.example.soso.community.votesboard.domain.entity.Votesboard;
import com.example.soso.community.votesboard.domain.entity.VotesboardLike;
import com.example.soso.community.votesboard.repository.VotesboardLikeRepository;
import com.example.soso.community.votesboard.repository.VotesboardRepository;
import com.example.soso.community.votesboard.service.VotesboardLikeService;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotesboardLikeServiceImpl
implements VotesboardLikeService {
    private final VotesboardLikeRepository votesboardLikeRepository;
    private final VotesboardRepository votesboardRepository;
    private final UsersRepository usersRepository;

    @Transactional
    public boolean toggleLike(Long votesboardId, String userId) {
        Votesboard votesboard = (Votesboard)this.votesboardRepository.findById((Object)votesboardId).orElseThrow(() -> new IllegalArgumentException("\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ID: " + votesboardId));
        Users user = (Users)this.usersRepository.findById(userId).orElseThrow(() -> new IllegalArgumentException("\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. ID: " + userId));
        return this.votesboardLikeRepository.findByVotesboardAndUser(votesboard, user).map(existingLike -> {
            this.votesboardLikeRepository.delete(existingLike);
            return false;
        }).orElseGet(() -> {
            VotesboardLike newLike = VotesboardLike.create((Votesboard)votesboard, (Users)user);
            this.votesboardLikeRepository.save((Object)newLike);
            return true;
        });
    }

    public boolean isLikedByUser(Long votesboardId, String userId) {
        return this.votesboardLikeRepository.existsByVotesboardIdAndUserId(votesboardId, userId);
    }

    public long getLikeCount(Long votesboardId) {
        return this.votesboardLikeRepository.countByVotesboardId(votesboardId);
    }

    @Generated
    public VotesboardLikeServiceImpl(VotesboardLikeRepository votesboardLikeRepository, VotesboardRepository votesboardRepository, UsersRepository usersRepository) {
        this.votesboardLikeRepository = votesboardLikeRepository;
        this.votesboardRepository = votesboardRepository;
        this.usersRepository = usersRepository;
    }
}

