/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.kakao.controller;

import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.kakao.dto.KakaoLoginRequest;
import com.example.soso.kakao.dto.KakaoLoginResponse;
import com.example.soso.kakao.service.KakaoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Auth", description="\uc778\uc99d/\uc778\uac00 \uad00\ub828 API")
@RestController
@RequestMapping(value={"/auth/kakao"})
public class KakaoAuthController {
    private final KakaoService kakaoService;

    @Operation(summary="\uce74\uce74\uc624 \ub85c\uadf8\uc778", description="\uce74\uce74\uc624 \uc778\uac00 \ucf54\ub4dc\ub97c \ud1b5\ud574 \uc0ac\uc6a9\uc790 \ub85c\uadf8\uc778\uc744 \ucc98\ub9ac\ud569\ub2c8\ub2e4.\n\n**\ud1a0\ud070 \ubc1c\uae09 \ubc29\uc2dd:**\n- Response Body: accessToken \ud3ec\ud568 (\ubaa8\ubc14\uc77c \uc571 \uc9c0\uc6d0)\n- Set-Cookie \ud5e4\ub354: accessToken, refreshToken \ucfe0\ud0a4 \uc124\uc815 (\uc6f9 \ube0c\ub77c\uc6b0\uc800 \uc790\ub3d9 \uad00\ub9ac)\n\n**\ucfe0\ud0a4 \ubcf4\uc548 \uc18d\uc131:**\n- accessToken: HttpOnly=true, Secure=true, SameSite=None (XSS \ubc29\uc5b4, 30\ubd84)\n- refreshToken: HttpOnly=true, Secure=true, SameSite=None (XSS \ubc29\uc5b4, 14\uc77c)\n\n**\ud074\ub77c\uc774\uc5b8\ud2b8\ubcc4 \uc0ac\uc6a9 \ubc29\ubc95:**\n- \uc6f9 \ube0c\ub77c\uc6b0\uc800: \ucfe0\ud0a4 \uc790\ub3d9 \uad00\ub9ac, credentials: 'include' \uc124\uc815 \ud544\uc694\n- \ubaa8\ubc14\uc77c \uc571: Body\uc5d0\uc11c accessToken \ucd94\ucd9c \ud6c4 AsyncStorage/SharedPreferences \uc800\uc7a5\n\n**\uae30\uc874 \uc0ac\uc6a9\uc790:** JWT \ud1a0\ud070 \ubc0f \uc0ac\uc6a9\uc790 \uc815\ubcf4 \ubc18\ud658\n**\uc2e0\uaddc \uc0ac\uc6a9\uc790:** \ud68c\uc6d0\uac00\uc785 \uc138\uc158 \uc0dd\uc131\n", responses={@ApiResponse(responseCode="200", description="\ub85c\uadf8\uc778 \uc131\uacf5", content={@Content(schema=@Schema(implementation=KakaoLoginResponse.class), examples={@ExampleObject(name="\uae30\uc874 \uc0ac\uc6a9\uc790", description="\uae30\uc874 \uc0ac\uc6a9\uc790 \ub85c\uadf8\uc778 - \ud1a0\ud070 \ubc0f \uc0ac\uc6a9\uc790 \uc815\ubcf4 \ubc18\ud658", value="{\"isNewUser\": false, \"accessToken\": \"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...\", \"user\": {\"id\": \"550e8400-e29b-41d4-a716-446655440000\", \"username\": \"\ud64d\uae38\ub3d9\", \"nickname\": \"\uae38\ub3d9\uc774\", \"email\": \"user@example.com\", \"userType\": \"FOUNDER\", \"gender\": \"MALE\", \"ageRange\": \"TWENTIES\", \"location\": \"\uc11c\uc6b8\uc2dc \uac15\ub0a8\uad6c\", \"createdAt\": \"2024-01-01T00:00:00\", \"updatedAt\": \"2024-01-01T00:00:00\"}}"), @ExampleObject(name="\uc2e0\uaddc \uc0ac\uc6a9\uc790", description="\uc2e0\uaddc \uc0ac\uc6a9\uc790 - \ud68c\uc6d0\uac00\uc785 \uc138\uc158 \uc0dd\uc131\ub428", value="{\"isNewUser\": true, \"accessToken\": null, \"user\": null}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad \ud615\uc2dd \ub610\ub294 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc778\uac00 \ucf54\ub4dc", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc694\uccad", description="\ud544\uc218 \ud30c\ub77c\ubbf8\ud130 \ub204\ub77d \ub610\ub294 \ud615\uc2dd \uc624\ub958", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[code] \uac12\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.\"}"), @ExampleObject(name="\uce74\uce74\uc624 \uc778\uc99d \uc2e4\ud328", description="\uce74\uce74\uc624 OAuth \uc778\uc99d \uc2e4\ud328", value="{\"code\": \"EXTERNAL_API_CLIENT_ERROR\", \"message\": \"\uc678\ubd80 API \ud638\ucd9c\uc774 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc694\uccad \uc815\ubcf4\ub97c \ud655\uc778\ud574\uc8fc\uc138\uc694.\"}")})}), @ApiResponse(responseCode="500", description="\uc11c\ubc84 \ub0b4\ubd80 \uc624\ub958", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc11c\ubc84 \uc624\ub958", description="\uc608\uc0c1\uce58 \ubabb\ud55c \uc11c\ubc84 \uc624\ub958", value="{\"code\": \"INTERNAL_SERVER_ERROR\", \"message\": \"\uc608\uc0c1\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="502", description="\uc678\ubd80 API \ud1b5\uc2e0 \uc624\ub958", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc678\ubd80 \uc11c\ube44\uc2a4 \uc624\ub958", description="\uce74\uce74\uc624 \uc11c\ubc84 \uc624\ub958", value="{\"code\": \"EXTERNAL_API_SERVER_ERROR\", \"message\": \"\uc678\ubd80 \uc11c\ube44\uc2a4\uc640\uc758 \ud1b5\uc2e0 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc7a0\uc2dc \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574\uc8fc\uc138\uc694.\"}")})})})
    @PostMapping(value={"/login"})
    public ResponseEntity<KakaoLoginResponse> kakaoLogin(@RequestBody KakaoLoginRequest request, HttpSession session, HttpServletResponse response) {
        KakaoLoginResponse result = this.kakaoService.login(request.code(), request.codeVerifier(), request.redirectUri(), session, response);
        return ResponseEntity.ok((Object)result);
    }

    @Generated
    public KakaoAuthController(KakaoService kakaoService) {
        this.kakaoService = kakaoService;
    }
}

