/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.kakao.service;

import com.example.soso.global.config.CookieUtil;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.global.jwt.JwtProperties;
import com.example.soso.global.jwt.JwtProvider;
import com.example.soso.global.redis.RefreshTokenRedisRepository;
import com.example.soso.kakao.dto.KakaoLoginResponse;
import com.example.soso.users.domain.dto.UserMapper;
import com.example.soso.users.domain.dto.UserResponse;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class UserLoginService {
    private final UsersRepository userRepository;
    private final JwtProvider jwtProvider;
    private final JwtProperties jwtProperties;
    private final RefreshTokenRedisRepository refreshTokenService;
    private final UserMapper userMapper;
    private final CookieUtil cookieUtil;

    public boolean isRegistered(String email) {
        return this.userRepository.existsByEmail(email);
    }

    public KakaoLoginResponse login(String email, HttpServletResponse response) {
        Users user = (Users)this.userRepository.findByEmailWithInterests(email).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
        String accessToken = this.jwtProvider.generateAccessToken(user.getId());
        String refreshToken = this.jwtProvider.generateRefreshToken();
        this.refreshTokenService.save(refreshToken, user.getId(), this.jwtProperties.getRefreshTokenValidityInMs());
        this.cookieUtil.addAccessTokenCookie(response, accessToken, this.jwtProperties.getAccessTokenValidityInMs());
        this.cookieUtil.addRefreshTokenCookie(response, refreshToken, this.jwtProperties.getRefreshTokenValidityInMs());
        UserResponse userResponse = this.userMapper.toUserResponse(user);
        return new KakaoLoginResponse(false, accessToken, userResponse);
    }

    @Generated
    public UserLoginService(UsersRepository userRepository, JwtProvider jwtProvider, JwtProperties jwtProperties, RefreshTokenRedisRepository refreshTokenService, UserMapper userMapper, CookieUtil cookieUtil) {
        this.userRepository = userRepository;
        this.jwtProvider = jwtProvider;
        this.jwtProperties = jwtProperties;
        this.refreshTokenService = refreshTokenService;
        this.userMapper = userMapper;
        this.cookieUtil = cookieUtil;
    }
}

