/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.security.config;

import com.example.soso.global.jwt.JwtProvider;
import com.example.soso.security.config.JwtSecurityDsl;
import com.example.soso.security.filter.ExceptionHandlerFilter;
import com.example.soso.security.filter.JwtAuthenticationFilter;
import com.example.soso.security.handler.JwtAccessDeniedHandler;
import com.example.soso.security.handler.JwtAuthenticationEntryPoint;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
public class SecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private final JwtProvider jwtProvider;
    private final UserDetailsService userDetailsService;
    private final CorsConfigurationSource corsConfigurationSource;
    private final JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint;
    private final JwtAccessDeniedHandler jwtAccessDeniedHandler;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.cors(cors -> cors.configurationSource(this.corsConfigurationSource)).csrf(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).rememberMe(AbstractHttpConfigurer::disable).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(exceptions -> exceptions.authenticationEntryPoint((AuthenticationEntryPoint)this.jwtAuthenticationEntryPoint).accessDeniedHandler((AccessDeniedHandler)this.jwtAccessDeniedHandler)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"OPTIONS", "/**"})).permitAll().requestMatchers(new String[]{"/auth/**", "/login/**", "/signup/**", "/swagger-ui/**", "/v3/api-docs/**", "/kafka/**", "/actuator/health"})).permitAll().requestMatchers(new String[]{"GET", "/community/freeboard/**"})).permitAll().anyRequest()).authenticated()).with((SecurityConfigurerAdapter)JwtSecurityDsl.customDsl(), dsl -> dsl.enable(true));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public JwtAuthenticationFilter jwtAuthenticationFilter() {
        return new JwtAuthenticationFilter(this.jwtProvider, this.userDetailsService);
    }

    @Bean
    public ExceptionHandlerFilter exceptionHandlerFilter() {
        return new ExceptionHandlerFilter();
    }

    @Bean
    public AuthenticationManager authenticationManager(HttpSecurity http) throws Exception {
        return (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
    }

    @Generated
    public SecurityConfig(JwtProvider jwtProvider, UserDetailsService userDetailsService, CorsConfigurationSource corsConfigurationSource, JwtAuthenticationEntryPoint jwtAuthenticationEntryPoint, JwtAccessDeniedHandler jwtAccessDeniedHandler) {
        this.jwtProvider = jwtProvider;
        this.userDetailsService = userDetailsService;
        this.corsConfigurationSource = corsConfigurationSource;
        this.jwtAuthenticationEntryPoint = jwtAuthenticationEntryPoint;
        this.jwtAccessDeniedHandler = jwtAccessDeniedHandler;
    }
}

