/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.service;

import com.example.soso.community.common.comment.domain.repository.CommentRepository;
import com.example.soso.community.voteboard.domain.dto.VotePostCreateRequest;
import com.example.soso.community.voteboard.domain.dto.VotePostDetailResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostListResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostMapper;
import com.example.soso.community.voteboard.domain.dto.VotePostSummaryResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostUpdateRequest;
import com.example.soso.community.voteboard.domain.dto.VoteRequest;
import com.example.soso.community.voteboard.domain.entity.VoteOption;
import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.community.voteboard.domain.entity.VoteResult;
import com.example.soso.community.voteboard.domain.entity.VoteStatus;
import com.example.soso.community.voteboard.repository.VoteOptionRepository;
import com.example.soso.community.voteboard.repository.VotePostLikeRepository;
import com.example.soso.community.voteboard.repository.VotePostRepository;
import com.example.soso.community.voteboard.repository.VoteResultRepository;
import com.example.soso.community.voteboard.service.VotePostService;
import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.domain.UserErrorCode;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.global.exception.util.UserAuthException;
import com.example.soso.users.domain.entity.Users;
import com.example.soso.users.repository.UsersRepository;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class VotePostServiceImpl
implements VotePostService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VotePostServiceImpl.class);
    private final VotePostRepository votePostRepository;
    private final VoteOptionRepository voteOptionRepository;
    private final VoteResultRepository voteResultRepository;
    private final UsersRepository usersRepository;
    private final CommentRepository commentRepository;
    private final VotePostLikeRepository votePostLikeRepository;
    private final VotePostMapper votePostMapper;

    @Transactional
    public Long createVotePost(VotePostCreateRequest request, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc2dc\uc791: userId={}, optionCount={}", (Object)userId, (Object)request.getVoteOptions().size());
        Users user = this.findUserById(userId);
        VotePost votePost = this.votePostMapper.toEntity(request, user);
        VotePost savedPost = (VotePost)this.votePostRepository.save((Object)votePost);
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc644\ub8cc: postId={}, optionCount={}", (Object)savedPost.getId(), (Object)savedPost.getVoteOptions().size());
        return savedPost.getId();
    }

    @Transactional
    public VotePostDetailResponse getVotePost(Long postId, String userId) {
        log.debug("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc870\ud68c: postId={}, userId={}", (Object)postId, (Object)userId);
        VotePost votePost = this.findVotePostById(postId);
        votePost.increaseViewCount();
        long commentCount = this.commentRepository.countByPostId(postId);
        long likeCount = this.votePostLikeRepository.countByVotePostId(postId);
        VoteResult userVoteResult = null;
        boolean isLiked = false;
        if (userId != null) {
            Users user = this.findUserById(userId);
            userVoteResult = this.voteResultRepository.findByUserAndVotePost(user, votePost).orElse(null);
            isLiked = this.votePostLikeRepository.existsByVotePostIdAndUserId(postId, userId);
        }
        return this.votePostMapper.toDetailResponse(votePost, commentCount, userVoteResult, likeCount, isLiked);
    }

    public VotePostListResponse getVotePostsByCursor(VoteStatus status, int size, Long cursor, String userId) {
        boolean hasNext;
        log.debug("\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c: status={}, size={}, cursor={}, userId={}", new Object[]{status, size, cursor, userId});
        PageRequest pageRequest = PageRequest.of((int)0, (int)(size + 1));
        LocalDateTime now = LocalDateTime.now();
        List posts = status == null ? (cursor == null ? this.votePostRepository.findAllWithoutStatus((Pageable)pageRequest) : this.votePostRepository.findAllByCursorWithoutStatus(cursor, (Pageable)pageRequest)) : (status == VoteStatus.IN_PROGRESS ? (cursor == null ? this.votePostRepository.findInProgress(now, (Pageable)pageRequest) : this.votePostRepository.findInProgressByCursor(cursor, now, (Pageable)pageRequest)) : (cursor == null ? this.votePostRepository.findCompleted(now, (Pageable)pageRequest) : this.votePostRepository.findCompletedByCursor(cursor, now, (Pageable)pageRequest)));
        boolean bl = hasNext = posts.size() > size;
        if (hasNext) {
            posts = posts.subList(0, size);
        }
        Long nextCursor = hasNext && !posts.isEmpty() ? ((VotePost)posts.get(posts.size() - 1)).getId() : null;
        List<VotePostSummaryResponse> summaries = posts.stream().map(post -> {
            long commentCount = this.commentRepository.countByPostId(post.getId());
            long likeCount = this.votePostLikeRepository.countByVotePostId(post.getId());
            boolean isLiked = userId != null && this.votePostLikeRepository.existsByVotePostIdAndUserId(post.getId(), userId);
            return this.votePostMapper.toSummaryResponse(post, commentCount, likeCount, isLiked);
        }).toList();
        return this.votePostMapper.toListResponse(summaries, nextCursor, hasNext);
    }

    @Transactional
    public void updateVotePost(Long postId, VotePostUpdateRequest request, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        VotePost votePost = this.findVotePostById(postId);
        Users user = this.findUserById(userId);
        this.validateAuthor(votePost, user);
        votePost.updatePost(request.getTitle(), request.getContent(), null);
        if (request.getEndTime() != null || request.getAllowRevote() != null) {
            LocalDateTime endTime = request.getEndTime() != null ? request.getEndTime() : votePost.getEndTime();
            boolean allowRevote = request.getAllowRevote() != null ? request.getAllowRevote().booleanValue() : votePost.isAllowRevote();
            votePost.updateVoteSettings(endTime, allowRevote);
        }
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc644\ub8cc: postId={}", (Object)postId);
    }

    @Transactional
    public void deleteVotePost(Long postId, String userId) {
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        VotePost votePost = this.findVotePostById(postId);
        Users user = this.findUserById(userId);
        this.validateAuthor(votePost, user);
        votePost.delete();
        log.info("\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc644\ub8cc: postId={}", (Object)postId);
    }

    @Transactional
    public void vote(Long postId, VoteRequest request, String userId) {
        log.info("\ud22c\ud45c \ucc38\uc5ec \uc2dc\uc791: postId={}, userId={}, optionId={}", new Object[]{postId, userId, request.getVoteOptionId()});
        VotePost votePost = this.findVotePostById(postId);
        Users user = this.findUserById(userId);
        VoteOption selectedOption = this.findVoteOptionById(request.getVoteOptionId());
        if (!votePost.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        if (this.voteResultRepository.existsByUserAndVotePost(user, votePost)) {
            throw new PostException((BaseErrorCode)PostErrorCode.ALREADY_VOTED);
        }
        if (!selectedOption.getVotePost().getId().equals(postId)) {
            throw new PostException((BaseErrorCode)PostErrorCode.INVALID_VOTE_OPTION);
        }
        VoteResult voteResult = VoteResult.builder().user(user).votePost(votePost).voteOption(selectedOption).build();
        this.voteResultRepository.save((Object)voteResult);
        selectedOption.increaseVoteCount();
        votePost.increaseTotalVotes();
        log.info("\ud22c\ud45c \ucc38\uc5ec \uc644\ub8cc: postId={}, userId={}, optionId={}", new Object[]{postId, userId, request.getVoteOptionId()});
    }

    @Transactional
    public void changeVote(Long postId, VoteRequest request, String userId) {
        log.info("\ud22c\ud45c \ubcc0\uacbd \uc2dc\uc791: postId={}, userId={}, newOptionId={}", new Object[]{postId, userId, request.getVoteOptionId()});
        VotePost votePost = this.findVotePostById(postId);
        Users user = this.findUserById(userId);
        VoteOption newOption = this.findVoteOptionById(request.getVoteOptionId());
        if (!votePost.isAllowRevote()) {
            throw new PostException((BaseErrorCode)PostErrorCode.REVOTE_NOT_ALLOWED);
        }
        if (!votePost.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        VoteResult voteResult = (VoteResult)this.voteResultRepository.findByUserAndVotePost(user, votePost).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.VOTE_NOT_FOUND));
        if (voteResult.getVoteOption().getId().equals(newOption.getId())) {
            log.warn("\ub3d9\uc77c\ud55c \uc635\uc158\uc73c\ub85c \uc7ac\ud22c\ud45c \uc2dc\ub3c4: postId={}, userId={}, optionId={}", new Object[]{postId, userId, newOption.getId()});
            return;
        }
        voteResult.changeVote(newOption);
        log.info("\ud22c\ud45c \ubcc0\uacbd \uc644\ub8cc: postId={}, userId={}, newOptionId={}", new Object[]{postId, userId, request.getVoteOptionId()});
    }

    @Transactional
    public void cancelVote(Long postId, String userId) {
        log.info("\ud22c\ud45c \ucde8\uc18c \uc2dc\uc791: postId={}, userId={}", (Object)postId, (Object)userId);
        VotePost votePost = this.findVotePostById(postId);
        Users user = this.findUserById(userId);
        if (!votePost.isAllowRevote()) {
            throw new PostException((BaseErrorCode)PostErrorCode.REVOTE_NOT_ALLOWED);
        }
        if (!votePost.isActive()) {
            throw new PostException((BaseErrorCode)PostErrorCode.VOTE_CLOSED);
        }
        VoteResult voteResult = (VoteResult)this.voteResultRepository.findByUserAndVotePost(user, votePost).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.VOTE_NOT_FOUND));
        voteResult.getVoteOption().decreaseVoteCount();
        votePost.decreaseTotalVotes();
        this.voteResultRepository.delete((Object)voteResult);
        log.info("\ud22c\ud45c \ucde8\uc18c \uc644\ub8cc: postId={}, userId={}", (Object)postId, (Object)userId);
    }

    private Users findUserById(String userId) {
        return (Users)this.usersRepository.findById(userId).orElseThrow(() -> new UserAuthException((BaseErrorCode)UserErrorCode.USER_NOT_FOUND));
    }

    private VotePost findVotePostById(Long postId) {
        return (VotePost)this.votePostRepository.findByIdAndDeletedFalse(postId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.POST_NOT_FOUND));
    }

    private VoteOption findVoteOptionById(Long optionId) {
        return (VoteOption)this.voteOptionRepository.findById((Object)optionId).orElseThrow(() -> new PostException((BaseErrorCode)PostErrorCode.VOTE_OPTION_NOT_FOUND));
    }

    private void validateAuthor(VotePost votePost, Users user) {
        if (!votePost.getUser().getId().equals(user.getId())) {
            throw new UserAuthException((BaseErrorCode)UserErrorCode.UNAUTHORIZED_ACCESS);
        }
    }

    @Generated
    public VotePostServiceImpl(VotePostRepository votePostRepository, VoteOptionRepository voteOptionRepository, VoteResultRepository voteResultRepository, UsersRepository usersRepository, CommentRepository commentRepository, VotePostLikeRepository votePostLikeRepository, VotePostMapper votePostMapper) {
        this.votePostRepository = votePostRepository;
        this.voteOptionRepository = voteOptionRepository;
        this.voteResultRepository = voteResultRepository;
        this.usersRepository = usersRepository;
        this.commentRepository = commentRepository;
        this.votePostLikeRepository = votePostLikeRepository;
        this.votePostMapper = votePostMapper;
    }
}

